<?php
/**
 * Template Name: Order Submit
 * Handles product order submission
 */

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Load WordPress environment
require_once dirname(__FILE__, 4) . '/wp-load.php';
global $wpdb;

// Table name
$table_name = 'rumicare_orders';

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    wp_send_json_error('Invalid request method.');
}

// Sanitize and retrieve POST data
$product_id   = intval($_POST['product_id'] ?? 0);
$product_name = sanitize_text_field($_POST['product_name'] ?? '');
$price        = floatval($_POST['price'] ?? 0);
$name         = sanitize_text_field($_POST['name'] ?? '');
$email        = sanitize_email($_POST['email'] ?? '');
$contact      = sanitize_text_field($_POST['contact'] ?? '');
$address      = sanitize_textarea_field($_POST['address'] ?? '');

// Check required fields
if (!$product_id || !$name || !$contact) {
    wp_send_json_error('Please fill all required fields.');
}

// Insert data into rumicare_orders table
$inserted = $wpdb->insert(
    $table_name,
    [
        'product_id'   => $product_id,
        'product_name' => $product_name,
        'price'        => $price,
        'name'         => $name,
        'email'        => $email,
        'contact'      => $contact,
        'address'      => $address,
        'created_at'   => current_time('mysql'),
    ],
    [
        '%d', // product_id
        '%s', // product_name
        '%f', // price
        '%s', // name
        '%s', // email
        '%s', // contact
        '%s', // address
        '%s', // created_at
    ]
);

// Return JSON response
if ($inserted) {
    wp_send_json_success('Order submitted successfully!');
} else {
    wp_send_json_error('Database error: ' . $wpdb->last_error);
}
