<?php
/**
 * Template Name: About Us
 */
get_header();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>About Us</title>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    body {
        margin: 0;
        font-family: Arial, sans-serif;
        line-height: 1.6;
        color: #333;
    }

    /* Full width banner */
    .banner {
    width: 100%;
    height: 400px;
    background-image: url('https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/3ersfx3.png');
    background-repeat: no-repeat;       /* prevents tiling */
    background-position: center center; /* centers image */
    background-size: contain;           /* fits whole image within the container */
}

    .single-columns .column h2 {
        font-size: 25px;
        margin-bottom: 20px;
    }

    .single-columns .column p {
        max-width: 800px;
        margin: 0 auto 10px;
    }

    /* Single-column section */
     .single-columns {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        padding: 0px 20px;
        max-width: 1200px;
        margin: 0 auto;
        margin-top: -50px;
    }

    /* Two-column section */
    .two-columns {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        padding: 20px 20px;
        max-width: 1200px;
        margin: 0 auto;
        
        /*flex-direction: column;*/
        /*    margin-bottom: 20px;*/
    }
    

    .column {
        flex: 1;
        min-width: 300px;
        /*background-color: #f4f4f4;*/
        background-color:#afe9ff !important;
        padding: 20px;
        border-radius: 10px;
    }
    
      .column-mb {
            flex: 1;
            max-width: 300px;
                /*width:100%;*/
            background-color: #afe9ff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: rgba(0, 0, 0, 0.15) 1.95px 1.95px 2.6px;
        }

    .column-mb h3 {
        font-size: 19px;
        margin-bottom: 15px;
    }
    
    .column p, .column-mb p, .oth-bio, .credentials{
        font-size:13px;
    }
    
      i {
        padding: 10px;
        box-shadow: rgba(0, 0, 0, 0.1) 0px 1px 3px 0px, rgba(0, 0, 0, 0.06) 0px 1px 2px 0px;
        width: 45px;
      }
      
     i:hover {
        box-shadow: rgba(50, 50, 93, 0.25) 0px 2px 5px -1px, rgba(0, 0, 0, 0.3) 0px 1px 3px -1px;
      }
      
    /**/
    
/* Profile Section */
.profile-section {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
    padding: 20px 20px;
    
    /*margin-top:20px;*/
}
.profile-section h3 {
    font-size: 28px;
    margin-bottom: 5px;
}
.profile-section p.title {
    font-weight: bold;
    color: #555;
    margin-bottom: 5px;
}
.profile-section p.credentials {
    color: #777;
    margin-bottom: 15px;
}
.social-icons a {
    display: inline-block;
    margin: 0 10px;
    font-size: 24px;
    color: #1e1e1e !important;
    text-decoration: none;
    transition: color 0.3s;
}
.social-icons a:hover {
    color: #fc3c68;
}

/* WhatsApp Button */
.whatsapp-btn {
    display: inline-block;
    background-color: #25D366;
    color: #fff !important;
    padding: 12px 25px;
    border-radius: 50px;
    font-weight: bold;
    text-decoration: none;
    /*margin-top: 20px;*/
    transition: background 0.3s;
}
.whatsapp-btn:hover {
    background-color: #1ebe57;
}

/* Large devices (laptops/desktops, 992px and up) */
@media only screen and (min-width: 992px) {
    .column-mb {
        flex: 1;
        max-width: 50%;
     }
     .profile-section {
        width: 70%;
        margin: auto;
    }
}


</style>
</head>
<body>

<!-- Banner Section -->
<div class="banner"></div>

<!-- Blue Background Section -->
<div class="single-columns">
    <div class="column">
        <h2>About Us</h2>
    <p>We are dedicated to supporting dairy farms with expert knowledge and innovative solutions. Our team of specialists strives to enhance productivity and sustainability in the dairy industry.</p>
    </div>
</div>



<!-- Two Column Section -->
<div class="two-columns">
    <div class="column-mb">
        <h3>Our Mission</h3>
        <p>To provide comprehensive, tailored support that improves dairy farm efficiency and profitability.</p>
    </div>
    <div class="column-mb">
        <h3>Our Vision</h3>
        <p>To be the leading partner in the transformation of the dairy farming sector through innovattive practices.</p>
    </div>
</div>

<!---->
<!-- Profile Section -->
<div class="profile-section">
    <h3>Dr. Muhammad Shafiq</h3>
    <p class="title">CEO & Lead Consultant</p>
    <p class="credentials">DVM, M.Phil (Animal Nutrition)</p>
    <p class="oth-bio">With over 15 years of experience in dairy farm management, Dr. Muhammad Shafiq specializes in milk production, herd health, and nutrition. As RumiCare’s founder, he is dedicated to delivering top-quality dairy services.</p>

</div>



<!-- WhatsApp Button -->
<!--<div class="profile-section">-->
<!--    <a href="https://wa.me/+923357136958" target="_blank" class="whatsapp-btn">Chat on WhatsApp: +92 335 713 6958</a>-->
<!--</div>-->


</body>
</html>

<?php get_footer(); ?>