<?php
/**
 * Template Name: All Products
 */

get_header();
global $wpdb;

$table = "rumicare_products";
$products = $wpdb->get_results("SELECT * FROM $table ORDER BY id DESC");

?>

<style>

/* ---------- PAGE TITLE ---------- */
h4 {
    font-size: 24px;
    font-weight: 600;
    text-align: center;
    margin-top:40px;
}

/* ---------- GRID WRAPPER ---------- */
.product-list {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(260px, 1fr));
    gap: 25px;
    padding: 20px 0px;
    width: 90%;
    max-width: 1300px;
    margin: 0 auto;
}

/* ---------- PRODUCT BOX ---------- */
.product-link {
    text-decoration: none !important;
    color: inherit !important;
}

.product-item {
    background: #ffffff;
    border-radius: 14px;
    overflow: hidden;
    box-shadow: 0 4px 12px rgba(0,0,0,0.10);
    transition: 0.3s;
    display: block; /* Desktop view = vertical */
}

.product-item:hover {
    transform: translateY(-4px);
    box-shadow: 0 6px 18px rgba(0,0,0,0.15);
}

/* ---------- IMAGE TOP (DESKTOP) ---------- */
.product-image img {
    width: 100%;
    height: 220px;
    object-fit: contain;
    background: #f7f7f7;
}

/* ---------- PRODUCT DETAILS ---------- */
.product-details {
    padding: 20px;
    text-align: center;
}

.product-details h3 {
    font-size: 22px;
    margin: 10px 0;
    color: #333;
    font-weight: 600;
}

.product-price {
    font-size: 18px;
    color: #fc3c68;
    font-weight: 700;
    margin-bottom: 8px;
}

.product-details p {
    font-size: 13px;
    color: #555;
    margin: 0px;
}

.product-seller {
    font-size: 14px;
    margin-top: 5px;
}

/* ---------- MOBILE VIEW (IMAGE LEFT + DETAILS RIGHT) ---------- */

@media (max-width: 768px) {

    .short_description {
        line-height: 20px;
        margin-bottom: 10px !important;
    }
    .product-list {
        grid-template-columns: 1fr; /* Only one per row */
    }

    .product-item {
        display: flex;
        flex-direction: row;
        align-items: center;
        /*height: 150px;*/
    }

    .product-image {
        width: 40%;
        height: 150px;
        overflow: hidden;
    }

    .product-image img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }

    .product-details {
        width: 60%;
        text-align: left;
        padding: 15px;
    }

    .product-details h3 {
        font-size: 18px;
        margin-bottom: 5px;
    }

    .product-price {
        font-size: 16px;
    }

}

/* ---------- GLOBAL FONT (same as category page) ---------- */
/*div, h1, h2, h3, h4, h5, h6, p, span, a {*/
/*    font-family: "League Spartan", Sans-serif !important;*/
/*}*/

</style>



<h4>All Products</h4>

<div class="product-list">

<?php 
foreach ($products as $p):

    $product_url = site_url('/product-detail/?id=' . $p->id);
    $image_url = get_stylesheet_directory_uri() . '/page-templates/Products-images/' . $p->image;
?>

    <a href="<?php echo esc_url($product_url); ?>" class="product-link">
        <div class="product-item">

            <div class="product-image">
                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_html($p->title); ?>">
            </div>

            <div class="product-details">
                <h3><?php echo esc_html($p->title); ?></h3>

                <p class="product-price">Rs <?php echo esc_html($p->price); ?></p>

                <p class="short_description"><?php echo esc_html(wp_trim_words($p->short_description, 15)); ?></p>

                <p class="product-seller">
                    Seller: <?php echo esc_html($p->seller_name); ?>
                </p>
            </div>

        </div>
    </a>

<?php endforeach; ?>

</div>

<?php get_footer(); ?>
