<?php
/**
 * Template Name: Blogs-temp
 */
get_header();
?>

<style>
    .banner-img{
        margin:auto;
        text-align:center;
    }
</style>
<style>/* ===============================
   Rumi Trainings Page Styling
================================= */

.training-content a {
   font-family: "League Spartan", Sans-serif;
    font-size: 10px;
    background: white;
    padding: 5px 10px 5px 10px;
}

.training-content a:hover {
   
    background-color: #007bff;
    color: #fff;
    border: none;
}
.rumi-trainings {
  width: 90%;
  margin: auto;
  padding: 20px 0;
}

.training-box {
  display: flex;
  flex-direction: row;
  flex-wrap: wrap;
  align-items: flex-start;
  background-color: #afe9ff;
  box-shadow: rgba(0, 0, 0, 0.16) 0px 1px 4px;
  border-radius: 8px;
  padding: 15px;
  margin-bottom: 20px;
  gap: 20px;
}

/* Left image */
.training-img {
  flex: 0 0 80px;
}

.training-img img {
  width: 80px;
  height: 80px;
  border-radius: 8px;
  object-fit: cover;
}

/* Right text */
.training-content {
  flex: 1;
}

.training-content h4 {
  margin: 0 0 5px;
  font-weight: 600;
  font-family: "League Spartan", Sans-serif;
      font-size: 16px;
    
}

div, h1, h2, h3, h4, h5, h6, p, span, ul, li, a {
    font-family: "League Spartan", Sans-serif !important;
}
.training-content p {
  margin: 0;
  color: #333;
  font-size: 13px;
  line-height: 15px;
    font-family: "League Spartan", Sans-serif;
     margin-bottom: 5px !important;
}

/* Details below both */
.training-details {
  width: 100%;
  margin-top: 15px;
}

.training-details a.btn {
  background-color: #007bff;
  color: #fff;
  border: none;
    font-family: "League Spartan", Sans-serif;
}

/* ✅ Custom tick list style */
.training-details ul {
  list-style: none;
  padding: 0;
  margin: 0 0 10px 0;
    font-family: "League Spartan", Sans-serif;
}

.training-details li {
      font-family: "League Spartan", Sans-serif;
  position: relative;
  padding-left: 35px;
  margin-bottom: 0px;
  font-size: 15px;
  color: #333;
}

/* Green circle + tick before each item */
.training-details li::before {
  content: "✔";
  position: absolute;
  left: 0;
  top: 50%;
  transform: translateY(-50%);
  background-color: #28a745; /* Green background */
  color: #fff;               /* White tick */
  font-weight: bold;
  font-size: 12px;
  border-radius: 50%;
  width: 20px;
  height: 20px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.training-details a.btn {
    display: flex;
    align-items: right !important;
    justify-content: flex-end;
    text-align: right !important;
    width: 31%;
    margin-left: auto;
    padding: 5px 15px 5px 12px;
}

.top-section h4 {
    margin: 0px;
    font-weight: 600;
    font-size: 22px;
}

.top-section p {
    font-size: 13px;
}

/* Responsive tweaks */
@media (max-width: 600px) {
  .training-img {
    flex: 0 0 80px;
  }

  .training-img img {
    width: 80px;
    height: 80px;
  }

}
</style>



<div class="banner-img">
    <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/10/45etdfxr5.png">
</div>


<div class="container-fluid rumi-trainings">

<div class="top-section">
    <h4>Blogs</h4>
    <p>Pratical knowledge for better dairy farming</p>
</div>

    <!-- Section#1-->
   <div class="training-box d-flex flex-wrap align-items-center">
        <div class="training-content">
      <h4>Animal Nutrition</h4>
      <p>Balanced rations, silage, minerals, DCAD, milk production tips.</p>
       <a href="https://rumicare.bibigadgets.com/category/animal-nutrition/">View More</a>
    </div>
    
    <div class="training-img">
      <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/wrsdfzfc-1.png" alt="On-Farm Training">
    </div>
  </div>
  
   <!-- Section#2-->
   <div class="training-box d-flex flex-wrap align-items-center">
        <div class="training-content">
      <h4>Cow Breeding</h4>
      <p>Heat detection, AI timing, PD genetics & fertility improvement.</p>
       <a href="https://rumicare.bibigadgets.com/category/cow-breeding/">View More</a>
    </div>
    
    <div class="training-img">
      <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/wrsdfzfc-2.png" alt="On-Farm Training">
    </div>
  </div>
  
   <!-- Section#3-->
   <div class="training-box d-flex flex-wrap align-items-center">
        <div class="training-content">
      <h4>Animal Health & Vaccines</h4>
      <p>Disease prevention vaccination schedules & treatment guidance.</p>
       <a href="https://rumicare.bibigadgets.com/category/animal-health-vaccines/">View More</a>
    </div>
    
    <div class="training-img">
      <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/wrsdfzfc-3.png" alt="On-Farm Training">
    </div>
  </div>
  
  
   <!-- Section#4-->
   <div class="training-box d-flex flex-wrap align-items-center">
        <div class="training-content">
      <h4>General Management</h4>
      <p>Farm SOPs, staff management, hygiene & daily routines.</p>
       <a href="https://rumicare.bibigadgets.com/category/general-management/">View More</a>
    </div>
    
    <div class="training-img">
      <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/sdfsddfw-1.png" alt="On-Farm Training">
    </div>
  </div>
  
  
  
   <!-- Section#5-->
   <div class="training-box d-flex flex-wrap align-items-center">
        <div class="training-content">
      <h4>Calf Rearing</h4>
      <p>Colostrum milk feeding, housing & future heifer care.</p>
       <a href="https://rumicare.bibigadgets.com/category/calf-rearing/">View More</a>
    </div>
    
    <div class="training-img">
      <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/wrsdfzfc-4.png" alt="On-Farm Training">
    </div>
  </div>
  

  

  
  
</div>



<?php get_footer(); ?>
