<?php
/**
 * Template Name: Edit Farm Job Page
 * Description: Allows a logged-in farmer to edit their job.
 */

get_header();
global $wpdb;

session_start();

// Check if farmer is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'farm') {
    echo '<p style="color:red;">❌ You must be logged in as a farmer to edit jobs.</p>';
    get_footer();
    exit;
}

// Get job ID
$farm_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch job
if ($farm_id > 0) {
    $farm = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM farm_jobs WHERE id = %d AND farmer_id = %d",
        $farm_id,
        $_SESSION['user_id']
    ));
} else {
    $farm = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM farm_jobs WHERE farmer_id = %d ORDER BY id DESC LIMIT 1",
        $_SESSION['user_id']
    ));
}

if (!$farm) {
    echo '<p style="color:red;">❌ Unauthorized access or job not found!</p>';
    get_footer();
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $role = sanitize_text_field($_POST['role']);
    $experience = sanitize_text_field($_POST['experience']);
    $key_requirements = sanitize_textarea_field($_POST['key_requirements']);
    $farm_name = sanitize_text_field($_POST['farm_name']);
    $total_animals = intval($_POST['total_animals']);
    $milking_cows = intval($_POST['milking_cows']);
    $address = sanitize_text_field($_POST['address']);
    $city = sanitize_text_field($_POST['city']);
    $farm_about = sanitize_textarea_field($_POST['farm_about']);
    $salary_package = sanitize_text_field($_POST['salary']);
    $benefits = !empty($_POST['benefits']) ? implode(",", array_map('sanitize_text_field', $_POST['benefits'])) : '';
    $job_visibility = sanitize_text_field($_POST['job_visibility']);


    $updated = $wpdb->update(
    'farm_jobs',
    [
        'role' => $role,
        'experience' => $experience,
        'key_requirements' => $key_requirements,
        'farm_name' => $farm_name,
        'total_animals' => $total_animals,
        'milking_cows' => $milking_cows,
        'address' => $address,
        'city' => $city,
        'farm_about' => $farm_about,
        'salary_package' => $salary_package,
        'benefits' => $benefits,
        'job_visibility' => $job_visibility   // ✅ ADDED
    ],
    ['id' => $farm->id, 'farmer_id' => $_SESSION['user_id']],
    ['%s','%s','%s','%s','%d','%d','%s','%s','%s','%s','%s'],  // add one more %s
    ['%d','%d']
);


    if ($updated !== false) {
        echo '<p style="color:green;">✅ Job updated successfully!</p>';
        $farm = $wpdb->get_row($wpdb->prepare(
            "SELECT * FROM farm_jobs WHERE id = %d AND farmer_id = %d",
            $farm->id,
            $_SESSION['user_id']
        ));
    } else {
        echo '<p style="color:red;">❌ Failed to update the job. Try again.</p>';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Edit Farm Job</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
    body { background-color: #f8f9fa; }

    .form-section {
      background: #ffffff;
      padding: 25px;
      border-radius: 12px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      margin-bottom: 30px;
      margin-left:15px;
      margin-right:15px;
    }

    .form-control { border-radius: 3px !important; }

    .form-heading {
      font-weight: bold;
      font-size:15px;
      margin-bottom: 20px;
      border-bottom: 2px solid #dee2e6;
      padding-bottom: 5px;
      color:red;
    }

    .head-texttt{
      font-family: "League Spartan", Sans-serif !important;
      font-weight: 600;
      color: #000000;
      font-size:16px;
    }

    .head-texttt1{
      font-family: "League Spartan", Sans-serif !important;
      font-weight: 600;
      color: #000000;
      font-size:13px;
      font-style: italic;
    }

    .main-sec {
      width: 90%;
      margin: auto;
      padding: 20px 15px 0px 15px;
    }

    .text-endd{   
      width: 90%;
      margin: auto;
    }

    .text-endd button {
      width: 100%;
      font-size: 14px;
      padding-top: 6px;
    }
select.form-select {
    padding: 9px 20px;
}
  </style>
</head>
<body>

<div class="main-sec">
   <div class="d-flex justify-content-between align-items-center">
      <div class="left-text">
        <span class="head-texttt">Edit Job</span><br>
         <span class="head-texttt1">(Update your posted farm job details)</span><br>
      </div>
      <div class="right-icon">
        <img style="height:50px;width:50px" src="<?php echo get_template_directory_uri(); ?>/page-templates/43wedsde.png" alt="Icon">
      </div>
   </div>
</div>

<div class="container my-5">
<form method="POST" action="<?php echo get_template_directory_uri(); ?>/page-templates/farm-job-update.php">
    <input type="hidden" name="job_id" value="<?php echo esc_attr($farm->id); ?>">

    <!-- Section: Job Role -->
    <div class="form-section">
      <div class="form-heading">Are You Looking For a</div>

   <div class="mb-3">
          <label class="form-label d-block">Select Role</label>
          <select class="form-select" name="role" required>
        
            <!-- Group 1 -->
            <option disabled style="color:red">Veterinary & Farm Management</option>
            <option value="Veterinary Doctor (DVM)" 
              <?php echo ($farm->role == 'Veterinary Doctor (DVM)') ? 'selected' : ''; ?>>
              Veterinary Doctor (DVM)
            </option>
        
            <option value="Veterinary Doctor & Farm Manager" 
              <?php echo ($farm->role == 'Veterinary Doctor & Farm Manager') ? 'selected' : ''; ?>>
              Veterinary Doctor & Farm Manager
            </option>
        
            <option value="Veterinary Assistant (VA)" 
              <?php echo ($farm->role == 'Veterinary Assistant (VA)') ? 'selected' : ''; ?>>
              Veterinary Assistant (VA)
            </option>
        
            <option value="Artificial Insemination Technician (AIT)" 
              <?php echo ($farm->role == 'Artificial Insemination Technician (AIT)') ? 'selected' : ''; ?>>
              Artificial Insemination Technician (AIT)
            </option>
        
            <option value="Dairy Farm Consultant" 
              <?php echo ($farm->role == 'Dairy Farm Consultant') ? 'selected' : ''; ?>>
              Dairy Farm Consultant
            </option>
        
            <option value="Dairy Nutritionist" 
              <?php echo ($farm->role == 'Dairy Nutritionist') ? 'selected' : ''; ?>>
              Dairy Nutritionist
            </option>
        
            <option value="Dairy Farm Supervisor" 
              <?php echo ($farm->role == 'Dairy Farm Supervisor') ? 'selected' : ''; ?>>
              Dairy Farm Supervisor
            </option>
        
            <!-- Group 2 -->
            <option disabled style="color:red">Farm Operations</option>
            <option value="Milkers" 
              <?php echo ($farm->role == 'Milkers') ? 'selected' : ''; ?>>
              Milkers
            </option>
        
            <option value="Tractor Drivers" 
              <?php echo ($farm->role == 'Tractor Drivers') ? 'selected' : ''; ?>>
              Tractor Drivers
            </option>
        
            <option value="Data Entry Operator" 
              <?php echo ($farm->role == 'Data Entry Operator') ? 'selected' : ''; ?>>
              Data Entry Operator
            </option>
        
            <option value="Dairy Accountant" 
              <?php echo ($farm->role == 'Dairy Accountant') ? 'selected' : ''; ?>>
              Dairy Accountant
            </option>
        
          </select>
    </div>


      <div class="mb-3">
        <label class="form-label">Minimum Experience</label>
        <input type="text" name="experience" class="form-control" value="<?php echo esc_attr($farm->experience); ?>" placeholder="e.g. 2 Years">
      </div>

      <div class="mb-3">
        <label class="form-label">Key Requirements</label>
        <textarea name="key_requirements" class="form-control" rows="6"><?php echo esc_textarea($farm->key_requirements); ?></textarea>
      </div>
    </div>

    <!-- Section: Dairy Farm Information -->
    <div class="form-section">
      <div class="form-heading">Dairy Farm Information</div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label">Dairy Farm Name</label>
          <input type="text" name="farm_name" class="form-control" value="<?php echo esc_attr($farm->farm_name); ?>" required>
        </div>

        <div class="col-md-6 mb-3">
          <label class="form-label">Total Animals</label>
          <input type="number" name="total_animals" class="form-control" value="<?php echo esc_attr($farm->total_animals); ?>" required>
        </div>

        <div class="col-md-6 mb-3">
          <label class="form-label">Milking Cows</label>
          <input type="number" name="milking_cows" class="form-control" value="<?php echo esc_attr($farm->milking_cows); ?>" required>
        </div>

        <div class="col-md-6 mb-3">
          <label class="form-label">Address</label>
          <input type="text" name="address" class="form-control" value="<?php echo esc_attr($farm->address); ?>" required>
        </div>

        <div class="col-md-6 mb-3">
          <label class="form-label">City</label>
          <input type="text" name="city" class="form-control" value="<?php echo esc_attr($farm->city); ?>" required>
        </div>

        <div class="col-12 mb-3">
          <label class="form-label">More About Dairy Farm (optional)</label>
          <textarea name="farm_about" class="form-control" rows="6"><?php echo esc_textarea($farm->farm_about); ?></textarea>
        </div>
      </div>
    </div>

    <!-- Section: Salary & Benefits -->
    <div class="form-section">
      <div class="form-heading">Salary Package & Other Benefits</div>

      <div class="mb-3">
        <label class="form-label d-block">Salary Package</label>
        <?php
        $salaries = ['30,000 - 50,000', '50,000 - 100,000', '100,000 - 150,000', 'Above 150,000'];
        foreach ($salaries as $salary) {
          $checked = ($farm->salary_package === $salary) ? 'checked' : '';
          echo '<div class="form-check">
                  <input class="form-check-input" type="radio" name="salary" value="'.esc_attr($salary).'" '.$checked.'>
                  <label class="form-check-label">'.esc_html($salary).'</label>
                </div>';
        }
        ?>
      </div>

      <div class="mb-3">
        <label class="form-label d-block">Other Benefits</label>
        <?php
        $benefit_list = ['Meal & Residency', 'Bonus on Performance Base'];
        $selected_benefits = explode(",", $farm->benefits);

        foreach ($benefit_list as $b) {
          $checked = in_array($b, $selected_benefits) ? 'checked' : '';
          echo '<div class="form-check">
                  <input class="form-check-input" type="checkbox" name="benefits[]" value="'.esc_attr($b).'" '.$checked.'>
                  <label class="form-check-label">'.esc_html($b).'</label>
                </div>';
        }
        ?>
      </div>
      
          <div class="mb-3">
                <label class="form-label d-block">Post a Job</label>
                
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="job_visibility" value="public"
                    <?php echo ($farm->job_visibility === 'public') ? 'checked' : ''; ?>>
                    <label class="form-check-label">Publicly</label>
                    <span> — this job will appear on website</span>
                </div>
            
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="job_visibility" value="confidential"
                    <?php echo ($farm->job_visibility === 'confidential') ? 'checked' : ''; ?>>
                    <label class="form-check-label">Confidential</label>
                    <span> — job will NOT appear publicly</span>
                </div>
          </div>

    </div>

    <!-- Submit Button -->
    <div class="text-endd">
      <button type="submit" class="btn btn-primary px-4">Update Job</button>
    </div>

  </form>
</div>

<?php get_footer('custom'); ?>
</body>
</html>
