<?php
/**
 * Template Name: Edit Product
 * Description: Frontend edit product form (same design as upload)
 */
get_header();

require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');
global $wpdb;

// Redirect if not logged in
// if (!is_user_logged_in()) {
//     wp_redirect(home_url());
//     exit;
// }

$current_user = wp_get_current_user();
$table_name = 'rumicare_products';

// Get product ID from URL
$product_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($product_id <= 0) {
    echo "<p style='color:red;'>Invalid product ID.</p>";
    get_footer();
    exit;
}

// Fetch product data
$product = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $product_id));
if (!$product) {
    echo "<p style='color:red;'>Product not found.</p>";
    get_footer();
    exit;
}

// Handle update form
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_product'])) {
    $title       = sanitize_text_field($_POST['title']);
    $price       = floatval($_POST['price']);
    $short_description = sanitize_textarea_field($_POST['short_description']);
    $description = sanitize_textarea_field($_POST['description']);
    $category    = sanitize_text_field($_POST['category']);
    $quantity    = intval($_POST['quantity']);
    $seller_name = sanitize_text_field($_POST['seller_name']);

    // Handle image upload
  $image = $product->image; // keep old image by default

if (!empty($_FILES['product_image']['name'])) {
    $upload_dir = get_template_directory() . '/page-templates/Products-images/';
    $filename = basename($_FILES['product_image']['name']);
    $target_file = $upload_dir . $filename;

    // ✅ Move new uploaded image to custom folder
    if (move_uploaded_file($_FILES['product_image']['tmp_name'], $target_file)) {

        // ✅ Delete old image file (if exists)
        $old_file = $upload_dir . $product->image;
        if (!empty($product->image) && file_exists($old_file)) {
            unlink($old_file);
        }

        // ✅ Save only filename in DB
        $image = $filename;
    }
}


    // Update record
    $wpdb->update(
        $table_name,
        array(
            'title'       => $title,
            'price'       => $price,
            'short_description' => $short_description,
            'description' => $description,
            'category'    => $category,
            'quantity'    => $quantity,
            'seller_name' => $seller_name,
            'image'       => $image,
        ),
        array('id' => $product_id)
    );

  echo "<script>
        alert('✅ Product updated successfully!');
        window.location.href='" . home_url('/super-admin-dashboard/') . "';
    </script>";


    // Refresh product data
    $product = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $product_id));
}
?>

<style>
.product-form-container {
  width: 90%;
  max-width: 650px;
  margin: 50px auto;
  background: #fff;
  padding: 30px 35px;
  border-radius: 12px;
  box-shadow: rgba(0, 0, 0, 0.1) 0 4px 10px;
  font-family: "Poppins", sans-serif;
}
.product-form-container h2 {
  text-align: center;
  margin-bottom: 25px;
  font-weight: 600;
  color: #333;
  font-size: 2rem;
}
.image-upload-section {
  display: flex;
  align-items: end;
  gap: 15px;
  margin-bottom: 15px;
}
.image-upload-box {
  width: 120px;
  height: 120px;
  border: 2px dashed #ccc;
  border-radius: 10px;
  display: flex;
  justify-content: center;
  align-items: center;
  overflow: hidden;
  background: #f9f9f9;
  transition: 0.3s ease;
  cursor: pointer;
}
.image-upload-box:hover {
  border-color: #007bff;
}
.image-upload-box img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}
.upload-btn {
  background: #007bff;
  color: #fff;
  border: none;
  border-radius: 6px;
  padding: 10px 20px;
  cursor: pointer;
  font-size: 14px;
  font-weight: 600;
  transition: 0.3s;
}
.upload-btn:hover { background: #0056b3; }
.hidden-file-input { display: none; }
.product-form-container input[type="text"],
.product-form-container input[type="number"],
.product-form-container select,
.product-form-container textarea {
  width: 100%;
  padding: 10px;
  margin-top: 8px;
  border: 1px solid #ccc;
  border-radius: 6px;
  font-size: 1rem;
  box-sizing: border-box;
  transition: 0.2s;
}
.product-form-container input:focus,
.product-form-container textarea:focus,
.product-form-container select:focus {
  border-color: #007bff;
  outline: none;
}
div, h1, h2, h3, h4, h5, h6, p, span, ul, li, a {
  font-family: "League Spartan", Sans-serif !important;
}
.form-row {
  display: flex;
  flex-wrap: wrap;
  gap: 15px;
}
.form-group {
  flex: 1 1 48%;
}
button.submit-btn {
  width: 100%;
  margin-top: 25px;
  padding: 12px;
  background: #007bff;
  border: none;
  color: #fff;
  border-radius: 6px;
  font-weight: 600;
  cursor: pointer;
  transition: background 0.3s;
  font-size: 1.1rem;
}
button.submit-btn:hover {
  background: #0056b3;
}
@media (max-width: 600px) {
  .form-row { flex-direction: column; }
  .image-upload-section { flex-direction: column; align-items: flex-start; }
}
</style>

<div class="product-form-container">
  <h2>Edit Product</h2>

  <form method="post" enctype="multipart/form-data">
    
    <label>Product Image</label>
    <div class="image-upload-section">
      <div class="image-upload-box" id="imagePreviewBox">
       <img id="previewImage" 
     src="https://rumicare.bibigadgets.com/wp-content/themes/onum/page-templates/Products-images/<?php echo esc_attr($product->image ?: '2ewdszx.png'); ?>" 
     alt="Preview">

        <input type="file" name="product_image" id="productImageInput" accept="image/*" class="hidden-file-input">
      </div>
      <button type="button" class="upload-btn" onclick="document.getElementById('productImageInput').click();">Change Image</button>
    </div>

    <label>Product Title</label>
    <input type="text" name="title" value="<?php echo esc_attr($product->title); ?>" required>

    <label>Price (in USD)</label>
    <input type="number" name="price" step="0.01" value="<?php echo esc_attr($product->price); ?>" required>

     <label>Short Description</label>
      <textarea name="short_description" rows="1" required><?php echo esc_textarea($product->short_description); ?></textarea>
    
    <label>Description</label>
    <textarea name="description" rows="4" required><?php echo esc_textarea($product->description); ?></textarea>

    <label>Category</label>
    <select name="category" required>
      <option value="">-- Select Category --</option>
      <option value="Nutritional-Products" <?php selected($product->category, 'Nutritional-Products'); ?>>Nutritional Products</option>
      <option value="Dairy-Equipment" <?php selected($product->category, 'Dairy-Equipment'); ?>>Dairy Equipment</option>
      <option value="Pharmaceutical" <?php selected($product->category, 'Pharmaceutical'); ?>>Pharmaceutical</option>
    </select>

    <div class="form-row">
      <div class="form-group">
        <label>Seller Name</label>
        <input type="text" name="seller_name" value="<?php echo esc_attr($product->seller_name); ?>" required>
      </div>
      <div class="form-group">
        <label>Quantity</label>
        <input type="number" name="quantity" value="<?php echo esc_attr($product->quantity); ?>" required>
      </div>
    </div>

    <button type="submit" name="update_product" class="submit-btn">Update Product</button>
  </form>
</div>

<script>
// ✅ Live image preview
document.getElementById('productImageInput').addEventListener('change', function(event) {
  const file = event.target.files[0];
  if (file) {
    const reader = new FileReader();
    reader.onload = function(e) {
      document.getElementById('previewImage').src = e.target.result;
    };
    reader.readAsDataURL(file);
  }
});
</script>

<?php get_footer(); ?>
