<?php
/**
 * Template Name: Edit User Profile
 * Description: Allows a logged-in user to edit their profile.
 */
get_header();
global $wpdb;

session_start(); // start session to access logged-in user

// --- Check if user is logged in ---
if (!isset($_SESSION['user_id'])) {
    echo '<div class="container mt-5"><div class="alert alert-danger text-center">Please login to edit your profile.</div></div>';
    get_footer();
    exit;
}

$user_id = intval($_SESSION['user_id']);

// --- Directory setup for image display ---
$upload_dir = get_template_directory() . '/page-templates/uploads/';
$upload_url = get_template_directory_uri() . '/page-templates/uploads/';


// --- Fetch data from user_profiles ---
$profile = $wpdb->get_row($wpdb->prepare("SELECT * FROM user_profiles WHERE user_id = %d", $user_id));
if (!$profile) {
    echo '<div class="container mt-5"><div class="alert alert-warning text-center">No profile found. Please create your profile first.</div></div>';
    get_footer();
    exit;
}

// --- Fetch data from user_info ---
$user_info = $wpdb->get_row($wpdb->prepare("SELECT * FROM user_info WHERE id = %d", $user_id));

// --- Fetch education and experience ---
$education = $wpdb->get_results($wpdb->prepare("SELECT * FROM user_education WHERE user_id = %d", $user_id));
$experience = $wpdb->get_results($wpdb->prepare("SELECT * FROM user_experience WHERE user_id = %d", $user_id));
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Edit User Profile</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@400;600;700&display=swap" rel="stylesheet">
  
   <link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>

  
  <style>
    body { background-color: #f8f9fa; font-family: 'League Spartan', sans-serif; }
    .form-section { background: #fff; padding: 25px; border-radius: 12px; margin-bottom: 30px; box-shadow: 0 0 10px rgba(0,0,0,0.05); }
    .form-heading { font-weight: 700; color: #fc3c68; border-bottom: 2px solid #f1f1f1; margin-bottom: 15px; padding-bottom: 5px;font-size: 18px; }
   .remove-btn { background-color:#dc3545; color:white; line-height:12px;padding-bottom: 2px;}

    .add-btn { background-color: #198754; color: white; }
    .profile-preview img { width: 120px; height: 120px; border-radius: 50%; border: 3px solid #fc3c68; object-fit:cover; }
    
     input,textarea,select{
        padding: 10px 10px !important;
         font-size: 13px !important;
    border-radius: 5px !important;
    } label{
        font-size: 15px;
    }
    
    button.btn.btn-danger.px-4.py-2
 {
     font-size:15px;
        width: 100%;
    }
    
    
 .crop-modal {
    display: none;
    position: fixed;
    top: 0; 
    left: 0;
    width: 100%; 
    height: 100%;
    background: rgba(0,0,0,0.7);
    justify-content: center;
    align-items: center;
    z-index: 99999;
    padding: 20px;
    box-sizing: border-box;
}

.crop-container {
    background: #fff;
    padding: 15px;
    border-radius: 12px;
    max-width: 90vw;      /* Limit popup width */
    max-height: 90vh;     /* Limit popup height */
    overflow: hidden;     /* Prevent image from overflowing */
    box-sizing: border-box;
}

.crop-container img {
    max-width: 100%;
    max-height: 70vh;     /* Image will never exceed screen height */
    width: auto;
    height: auto;
    display: block;
    margin: 0 auto;
}
.crop-close {
    position: absolute;
    top: 15px;
    right: 20px;
    font-size: 28px;
    font-weight: bold;
    color: #333;
    cursor: pointer;
    z-index: 999999;
    transition: 0.2s;
}

.crop-close:hover {
    color: #fc3c68;
}

  </style>
</head>
<body>

<div class="container my-5">
  <form method="POST" enctype="multipart/form-data" action="<?php echo esc_url(get_template_directory_uri() . '/page-templates/update-user-profile.php'); ?>">
    <input type="hidden" name="user_id" value="<?php echo esc_attr($user_id); ?>">

    <!-- Personal Info -->
    <div class="form-section">
      <h5 class="form-heading">Personal Information</h5>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label>Full Name</label>
          <input type="text" name="username" class="form-control" value="<?php echo esc_attr($user_info->username ?? ''); ?>" required>
        </div>

        <div class="col-md-6 mb-3">
          <label>Email Address</label>
          <input type="email" name="email" class="form-control" value="<?php echo esc_attr($user_info->email ?? ''); ?>">
        </div>

        <div class="col-md-6 mb-3">
          <label>New Password (leave blank to keep current)</label>
          <input type="password" name="password" class="form-control" placeholder="Enter new password if you want to change it">
        </div>

        <div class="col-md-6 mb-3">
          <label>Whatsapp No</label>
          <input type="text" name="contact" class="form-control" value="<?php echo esc_attr($user_info->contact ?? ''); ?>" required>
        </div>

        <div class="col-md-6 mb-3">
          <label>Birth Date</label>
          <input type="date" name="birthdate" class="form-control" value="<?php echo esc_attr($profile->birthdate ?? ''); ?>" required>
        </div>

        <div class="col-md-6 mb-3">
          <label>City</label>
          <input type="text" name="city" class="form-control" value="<?php echo esc_attr($profile->city ?? ''); ?>" required>
        </div>

        <div class="col-12 mb-3">
          <label>Description</label>
          <textarea name="bio" class="form-control" rows="3" required><?php echo esc_textarea($profile->bio ?? ''); ?></textarea>
        </div>

        <div class="col-12 mb-3">
          <label>Extra Skills (hold Ctrl to select multiple)</label>
          <select name="skills[]" multiple class="form-control">
            <?php
            $skills_list = ["Feed Formulation", "Hoof Trimming", "Artificial Insemination", "Pregnancy Diagnosis", "Minor Surgery", "Major Surgery", "Working on Excel Sheet", "Record Keeping on Software", "Calf Care", "Milking Parlor Handling"];
            $user_skills = array_filter(array_map('trim', explode(',', $profile->skills ?? '')));
            foreach ($skills_list as $skill) {
              $selected = in_array($skill, $user_skills) ? 'selected' : '';
              echo "<option value=\"$skill\" $selected>$skill</option>";
            }
            ?>
          </select>
        </div>

        
         <div class="form-section">
                <h5 class="form-heading">Profile Picture</h5>
            
                <!-- Current Image Preview -->
                <div class="profile-preview mb-3 text-center">
                    <img id="profilePreview" 
                         src="<?php echo $profile->image ? $upload_url . $profile->image : 'https://via.placeholder.com/120'; ?>">
                </div>
            
                <!-- File Input -->
                <input type="file" id="imageInput" accept="image/*" class="form-control">
            
                <!-- Hidden Base64 Image (sent to PHP) -->
                <input type="hidden" name="profile_image" id="profilePicCropped">
            
                <!-- Crop Popup -->
                <div id="cropModal" class="crop-modal">
                    <div class="crop-container position-relative">
                        <span class="crop-close">&times;</span>
                        <img id="cropImage">
                        <button id="cropButton" class="btn btn-success w-100 mt-3">Crop & Upload</button>
                    </div>
                </div>
            </div>

    </div>

    <!-- Education -->
    <div class="form-section">
      <h5 class="form-heading d-flex justify-content-between align-items-center">
        Education Records
        <button type="button" class="btn add-btn btn-sm" onclick="addEducation()">+ Add Education</button>
      </h5>
      <div id="education-container">
        <?php if ($education): foreach ($education as $edu): ?>
          <div class="border rounded p-3 mb-3 bg-light position-relative">
            <div class="row">
              <div class="col-md-4 mb-3"><label>Diploma/Degree</label><input type="text" name="course[]" class="form-control" value="<?php echo esc_attr($edu->course); ?>" required></div>
              <div class="col-md-4 mb-3"><label>Institute</label><input type="text" name="institute[]" class="form-control" value="<?php echo esc_attr($edu->institute); ?>" required></div>
              <div class="col-md-3 mb-3"><label>Completion Date</label><input type="date" name="year[]" class="form-control" value="<?php echo esc_attr($edu->completion_date); ?>"></div>
              <div class="col-md-1 mb-3 text-end"><button type="button" class="btn remove-btn" onclick="removeEducation(this)">×</button></div>
            </div>
          </div>
        <?php endforeach; endif; ?>
      </div>
    </div>

    <!-- Experience -->
    <div class="form-section">
      <h5 class="form-heading d-flex justify-content-between align-items-center">
        Work Experience
        <button type="button" class="btn add-btn btn-sm" onclick="addWorkExperience()">+ Add Experience</button>
      </h5>
      <div id="work-experience-container">
        <?php if ($experience): foreach ($experience as $exp): ?>
          <div class="border rounded p-3 mb-3 bg-light position-relative">
            <div class="row">
              <div class="col-md-4 mb-3"><label>Dairy Farm Name</label><input type="text" name="company_name[]" class="form-control" value="<?php echo esc_attr($exp->company_name); ?>"></div>
              <div class="col-md-4 mb-3"><label>Job Title</label><input type="text" name="job_designation[]" class="form-control" value="<?php echo esc_attr($exp->job_designation); ?>"></div>
              <div class="col-md-3 mb-3"><label>Start Date</label><input type="date" name="start_date[]" class="form-control" value="<?php echo esc_attr($exp->start_date); ?>"></div>
              <div class="col-md-3 mb-3"><label>End Date</label><input type="date" name="end_date[]" class="form-control" value="<?php echo esc_attr($exp->end_date); ?>"></div>
              <div class="col-md-6 mb-3"><label>Responsibilities</label><textarea name="work_responsibilities[]" class="form-control" rows="2"><?php echo esc_textarea($exp->work_responsibilities); ?></textarea></div>
              <div class="col-md-2 mb-3 text-end"><button type="button" class="btn remove-btn" onclick="removeWorkExperience(this)">×</button></div>
            </div>
          </div>
        <?php endforeach; endif; ?>
      </div>
    </div>

    <div class="text-end">
      <button type="submit" class="btn btn-danger px-4 py-2" style="background-color:#fc3c68; border:none;">Update Profile</button>
    </div>
  </form>
</div>

<script>
function addEducation() {
  const container = document.getElementById('education-container');
  const block = document.createElement('div');
  block.classList.add('border','rounded','p-3','mb-3','bg-light','position-relative');
  block.innerHTML = `<div class="row">
    <div class="col-md-4 mb-3"><label>Diploma/Degree</label><input type="text" name="course[]" class="form-control" required></div>
    <div class="col-md-4 mb-3"><label>Institute</label><input type="text" name="institute[]" class="form-control" required></div>
    <div class="col-md-3 mb-3"><label>Completion Date</label><input type="date" name="year[]" class="form-control"></div>
    <div class="col-md-1 mb-3 text-end"><button type="button" class="btn remove-btn" onclick="removeEducation(this)">×</button></div>
  </div>`;
  container.appendChild(block);
}
function removeEducation(btn){btn.closest('.border').remove();}
function addWorkExperience(){
  const container=document.getElementById('work-experience-container');
  const block=document.createElement('div');
  block.classList.add('border','rounded','p-3','mb-3','bg-light','position-relative');
  block.innerHTML=`<div class="row">
    <div class="col-md-4 mb-3"><label>Dairy Farm Name</label><input type="text" name="company_name[]" class="form-control"></div>
    <div class="col-md-4 mb-3"><label>Job Title</label><input type="text" name="job_designation[]" class="form-control"></div>
    <div class="col-md-3 mb-3"><label>Start Date</label><input type="date" name="start_date[]" class="form-control"></div>
    <div class="col-md-3 mb-3"><label>End Date</label><input type="date" name="end_date[]" class="form-control"></div>
    <div class="col-md-6 mb-3"><label>Responsibilities</label><textarea name="work_responsibilities[]" class="form-control" rows="2"></textarea></div>
    <div class="col-md-2 mb-3 text-end"><button type="button" class="btn remove-btn" onclick="removeWorkExperience(this)">×</button></div>
  </div>`;
  container.appendChild(block);
}
function removeWorkExperience(btn){btn.closest('.border').remove();}
</script>


<script>
let cropper;

document.getElementById("imageInput").addEventListener("change", function(e) {
    let file = e.target.files[0];
    if (!file) return;

    let reader = new FileReader();
    reader.onload = function(event) {

        document.getElementById("cropImage").src = event.target.result;
        document.getElementById("cropModal").style.display = "flex";

        if (cropper) cropper.destroy();

        cropper = new Cropper(document.getElementById("cropImage"), {
            aspectRatio: 1,
            viewMode: 1,
            responsive: true,
        });
    };
    reader.readAsDataURL(file);
});

// Close modal
document.querySelector(".crop-close").addEventListener("click", function() {
    document.getElementById("cropModal").style.display = "none";
    if (cropper) cropper.destroy();
});

// Crop & upload
document.getElementById("cropButton").addEventListener("click", function(e) {
    e.preventDefault();

    let canvas = cropper.getCroppedCanvas({
        width: 400,
        height: 400,
    });

    let base64image = canvas.toDataURL("image/png");

    // Set base64 image to hidden input
    document.getElementById("profilePicCropped").value = base64image;

    // Update preview
    document.getElementById("profilePreview").src = base64image;

    // Hide modal
    document.getElementById("cropModal").style.display = "none";

    cropper.destroy();
});
</script>

<script>
   // Close cropping modal
document.querySelector('.crop-close').addEventListener('click', function () {
    document.querySelector('.crop-modal').style.display = 'none';
    if (cropper) {
        cropper.destroy();
    }
});

</script>
</body>
</html>

<?php get_footer('custom'); ?>
