<?php
/**
 * Template Name: Farm Dashboard Page
 * Description: Displays farm owner personal info using session.
 */

get_header();
global $wpdb;

// Start session
session_start();

// Check if farm user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'farm') {
    echo '<script>alert("⚠️ Please login first!"); window.location.href="' . home_url('/login-page/') . '";</script>';
    exit;
}

// Get farmer ID from session
$farm_id = $_SESSION['user_id'];

// Fetch farm owner info
$farm = $wpdb->get_row($wpdb->prepare(
    "SELECT * FROM farmers_info WHERE id = %d LIMIT 1",
    $farm_id
));

if (!$farm) {
    echo "<div class='container mt-5'><div class='alert alert-danger'>Farm owner not found.</div></div>";
    get_footer();
    exit;
}


// ✅ Only allow logged-in farm users (optional — remove if not needed)
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'farm') {
    echo '<div class="alert alert-danger text-center mt-5">You must be logged in as a farm owner to view this page.</div>';
    get_footer();
    exit;
}

$farm_user_id = intval($_SESSION['user_id']);

// ✅ Get all jobs created by this farm
$jobs = $wpdb->get_results(
    $wpdb->prepare("SELECT id, role, city FROM farm_jobs WHERE farmer_id = %d", $farm_user_id)
);

?>
<?php
// Fetch all jobs for the logged-in farm user
$farmer_id = $_SESSION['user_id']; // Already set in your dashboard code

$jobs = $wpdb->get_results($wpdb->prepare(
    "SELECT id, role, city, salary_package, job_visibility, status
     FROM farm_jobs 
     WHERE farmer_id = %d 
     ORDER BY id DESC",
    $farmer_id
));
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Farm Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@400;600;700&display=swap" rel="stylesheet">

<style>
body { background-color: #f8f9fa; font-family: 'League Spartan', sans-serif; }
.main-sec { width: 90%; margin: auto; padding: 20px 15px 0px 15px; }
.info-section { background: #ffffff; padding: 25px; border-radius: 12px; box-shadow: 0 0 10px rgba(0,0,0,0.05); margin-bottom: 30px; }
.info-heading { font-weight: bold; font-size: 15px; margin-bottom: 20px; border-bottom: 2px solid #dee2e6; padding-bottom: 5px; color:red; }
.info-headingg { font-weight: bold; font-size: 18px; margin-bottom: 20px; padding-bottom: 5px; color:red; }

.info-label { font-weight: 600; color: #333; font-size: 14px; margin-right: 10px; }
.info-value { font-weight: 400; color: #000; font-size: 14px; }
.row-info { margin-bottom: 12px; }
td a {
    width: 30%;
}
</style>
</head>
<body>

<div class="main-sec">
   <div class="d-flex justify-content-between align-items-center mb-4">
      <div class="left-text">
        <span class="info-headingg">Farm Dashboard</span>
        <!--<span style="font-style: italic;">Your personal information</span>-->
      </div>
      <div class="right-icon">
        <img style="height:50px;width:50px" src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/Farm-Profile-pic-2.png" alt="Icon">
      </div>
   </div>

   <div class="info-section">
      <div class="info-heading">Personal Information</div>

      <div class="row row-info">
        <div class="col-md-6">
          <span class="info-label">Full Name:</span>
          <span class="info-value"><?php echo esc_html($farm->full_name); ?></span>
        </div>
        <div class="col-md-6">
          <span class="info-label">Email:</span>
          <span class="info-value"><?php echo esc_html($farm->email); ?></span>
        </div>
        
         <div class="col-md-6">
          <span class="info-label">WhatsApp No:</span>
          <span class="info-value"><?php echo esc_html($farm->contact); ?></span>
        </div>
        <div class="col-md-6">
          <span class="info-label">Created At:</span>
          <span class="info-value"><?php echo date('d M Y', strtotime($farm->created_at)); ?></span>
        </div>
      </div>

   </div>
   
   
   <!--Job posted section-->
     <div class="info-section">
<div class="full-width-header mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div class="header-left">Your Posted Jobs</div>
        <a href="https://rumicare.bibigadgets.com/farma-form/" class="btn btn-sm btn-primary btn-style">Post a Job</a>
    </div>
    <hr class="header-line">
</div>


        <?php if ($jobs && count($jobs) > 0): ?>
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Job Title</th>
                        <th>City</th>
                        <th>Salary</th>
                        <th>Job Visibilty</th>
                         <th>Job Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($jobs as $job): ?>
                        <tr>
                            <td><?php echo esc_html($job->role); ?></td>
                            <td><?php echo esc_html($job->city); ?></td>
                            <td><?php echo esc_html($job->salary_package); ?></td>
                            <td><?php echo esc_html($job->job_visibility) ?></td>
                             <td><?php echo esc_html($job->status) ?></td>
                            <td>
                                <a class="btn btn-sm btn-primary btn-style-view" href="https://rumicare.bibigadgets.com/farmar-detail-page/?id=<?php echo $job->id; ?>">View</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>No job posts found.</p>
        <?php endif; ?>
    </div>
    
    
    <!-Job application section--->
 <div class="info-section">
      <div class="info-heading">Job Applications Overview</div>

    <?php if (!empty($jobs)): ?>
        <table class="table table-bordered table-striped">
            <thead style="background-color:#fc3c68;color:#fff;">
                <tr>
                    <th>Job Title</th>
                    <th>City</th>
                    <th>Total Applications</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($jobs as $job): 
                    // Count total applications for this job
                    $application_count = $wpdb->get_var(
                        $wpdb->prepare("SELECT COUNT(*) FROM job_applications WHERE job_id = %d", $job->id)
                    );
                ?>
                    <tr>
                        <td><?php echo esc_html($job->role); ?></td>
                        <td><?php echo esc_html($job->city); ?></td>
                        <td><strong><?php echo intval($application_count); ?></strong></td>
                        <td>
                            <?php if ($application_count > 0): ?>
                                <a href="<?php echo home_url('/job-applicants-list/?job_id=' . $job->id); ?>" class="btn-application btn btn-sm btn-primary">
                                    View Applicants
                                </a>
                            <?php else: ?>
                                <span class="text-muted">No Applications</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <div class="alert alert-warning text-center">
            <strong>No jobs found!</strong> You haven’t posted any jobs yet.
        </div>
    <?php endif; ?>


   </div>
      </div>
      
</div>

<style>

.btn-application{
    background-color: green;
    padding: 5px 10px 3px 10px;
    border:none;
    color:white !important;
    width: auto;
}
.btn-style-view{
     background-color: green;
    width: 100%;border:none;
color:white !important;
}
.btn-style{
       padding: 5px 10px 3px 10px;
    background-color: #3173BD;
    font-family: "League Spartan", Sans-serif;
    font-weight: 600;
    color: white !important;
    text-decoration: none;
    font-size: 11px;
}
.full-width-header {
    width: 100%;
    margin-bottom: 20px;
}

.full-width-header .header-left {
    font-weight: bold;
    font-size: 15px;
    color: red;
}

.full-width-header .header-line {
    border: 0;
    height: 1px;
    background: #3173BD; /* line color */
    margin-top: 8px; /* space between flex row and line */
}
.table thead th {
    background-color: #3173BD;
    color: #fff;
    font-weight: 600;
}
.table tbody tr:hover {
    background-color: #f1f1f1;
}
.table td, .table th {
    vertical-align: middle;
}
</style>

</div>

</body>
</html>

<?php get_footer(); ?>
