<?php
// ==========================
// ✅ Farm Job Update Script (Final Optimized Version)
// ==========================

ini_set('display_errors', 1);
error_reporting(E_ALL);

// Fix session across subdomains
ini_set('session.cookie_path', '/');
ini_set('session.cookie_domain', '.rumicare.bibigadgets.com');
session_start();

// Load WordPress
require_once('../../../../wp-load.php');
global $wpdb;

// Validate job ID
$job_id = isset($_POST['job_id']) ? intval($_POST['job_id']) : 0;
if ($job_id <= 0) {
    die('❌ Invalid Job ID.');
}

// Session validation
if (empty($_SESSION['user_id']) || !in_array($_SESSION['user_type'], ['farm', 'farmer'])) {
    die('❌ Unauthorized access.');
}

$farmer_id = intval($_SESSION['user_id']);

// ==========================
// COLLECT FORM DATA
// ==========================

$role             = sanitize_text_field($_POST['role'] ?? '');
$experience       = sanitize_text_field($_POST['experience'] ?? '');
$farm_name        = sanitize_text_field($_POST['farm_name'] ?? '');
$total_animals    = intval($_POST['total_animals'] ?? 0);
$milking_cows     = intval($_POST['milking_cows'] ?? 0);
$address          = sanitize_text_field($_POST['address'] ?? '');
$city             = sanitize_text_field($_POST['city'] ?? '');
$farm_about       = sanitize_textarea_field($_POST['farm_about'] ?? '');
$key_requirements = sanitize_textarea_field($_POST['key_requirements'] ?? '');

// Salary (radio input name="salary")
$salary_package = sanitize_text_field($_POST['salary'] ?? '');

// Benefits
$benefits = isset($_POST['benefits']) ? array_map('sanitize_text_field', $_POST['benefits']) : [];
$benefits_str = implode(',', $benefits);

// Job Visibility
$job_visibility = sanitize_text_field($_POST['job_visibility'] ?? 'public');

// Status logic
$status = ($job_visibility === "public") ? "pending" : "approved";

// Update timestamp
$current_time = current_time('mysql');

// ==========================
// PREPARE UPDATE
// ==========================
$data = [
    'role'              => $role,
    'experience'        => $experience,
    'farm_name'         => $farm_name,
    'total_animals'     => $total_animals,
    'milking_cows'      => $milking_cows,
    'address'           => $address,
    'city'              => $city,
    'farm_about'        => $farm_about,
    'key_requirements'  => $key_requirements,
    'benefits'          => $benefits_str,
    'salary_package'    => $salary_package,
    'job_visibility'    => $job_visibility,
    'status'            => $status,  // <-- NEW
    'created_at'        => $current_time
];


$where = [
    'id'        => $job_id,
    'farmer_id' => $farmer_id
];

// ==========================
// RUN UPDATE QUERY
// ==========================
$updated = $wpdb->update('farm_jobs', $data, $where);

if ($updated === false) {
    echo "❌ Failed to update the job.<br>";
    echo "Database Error: " . esc_html($wpdb->last_error);
    exit;
}

// ==========================
// SUCCESS RESPONSE
// ==========================
echo "<script>
        alert('✅ Job updated successfully!');
        window.location.href = 'https://rumicare.bibigadgets.com/farm-dashboard/';
      </script>";
?>
