<?php
/**
 * Template Name: Forgot Password Template
 * Description: Allows users and farmers to reset their password.
 */

get_header();
global $wpdb;

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login_input = sanitize_text_field($_POST['login']);
    $user = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM user_info WHERE email = %s LIMIT 1",
        $login_input
    ));

    $user_type = 'user';
    if (!$user) {
        $user = $wpdb->get_row($wpdb->prepare(
            "SELECT * FROM farmars_info WHERE email = %s LIMIT 1",
            $login_input
        ));
        $user_type = 'farm';
    }

    if ($user) {
        // Generate unique token
        $token = wp_generate_password(32, false);
        $reset_link = home_url("/reset-password/?token=$token&type=$user_type");

        // Save token
        $wpdb->update(
            ($user_type === 'user' ? 'user_info' : 'farmars_info'),
            ['reset_token' => $token],
            ['id' => $user->id]
        );

        // Send email
        $subject = "Password Reset Request";
        $body = "Hello, click the link below to reset your password:\n\n$reset_link";
        $headers = ['Content-Type: text/plain; charset=UTF-8'];

        // You can comment this line during testing:
        wp_mail($login_input, $subject, $body, $headers);

        // For local debugging (optional):
        // echo "<div>Debug reset link: <a href='$reset_link'>$reset_link</a></div>";

        $message = '<div class="alert alert-success mt-3">✅ Password reset link has been sent to your email.</div>';
    } else {
        $message = '<div class="alert alert-danger mt-3">❌ No account found with that email.</div>';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Forgot Password</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
body { background-color: #f7f7f7; font-family: "League Spartan", sans-serif; }
.login-container { max-width: 420px; margin: 80px auto; background: #fff; padding: 35px; border-radius: 12px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
.btn-login { background-color: #fc3c68; color: #fff; font-weight: 600; border-radius: 8px; transition: all 0.3s ease; }
.btn-login:hover { background-color: #e1325c; transform: translateY(-2px); }

    @media screen and (max-width: 600px) {
     .login-container { max-width: 90%;}
    }

</style>
</head>
<body>

<div class="login-container">
  <h2 class="text-center mb-4">Forgot Password</h2>
  <?php echo $message; ?>
  <form method="post" action="">
    <div class="mb-3">
      <label class="form-label">Enter Your Registered Email</label>
      <input type="email" name="login" class="form-control" placeholder="Enter your email" required>
    </div>
    <div class="d-grid">
      <button type="submit" class="btn btn-login py-2">Send Reset Link</button>
    </div>
  </form>

  <div class="text-center mt-4">
    <p>Remember your password?</p>
    <a href="https://rumicare.bibigadgets.com/user-login-form/" class="btn btn-outline-primary">Back to Login</a>
  </div>
</div>

<?php get_footer('custom'); ?>
</body>
</html>
