<?php
// ✅ Include WordPress to access $wpdb and session
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');

if (!session_id()) session_start();

global $wpdb;

$action = $_GET['action'] ?? '';

/**
 * ==========================================================
 *  CHECK IF USER HAS PROFILE
 * ==========================================================
 */
if ($action === 'check_user_profile') {
    $user_id = $_SESSION['user_id'] ?? 0;
    $has_profile = false;

    if ($user_id) {
        $count = $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(*) FROM user_profiles WHERE user_id = %d",
            $user_id
        ));
        $has_profile = $count > 0;
    }

    echo json_encode(['has_profile' => $has_profile]);
    exit;
}

/**
 * ==========================================================
 *  FETCH COMPLETE USER PROFILE DATA (for Apply Job Modal)
 * ==========================================================
 */
if ($action === 'get_loggedin_user_profile') {
    if (!isset($_SESSION['user_id'])) {
        echo '<div class="alert alert-danger text-center mt-3">You must be logged in to apply for this job.</div>';
        echo '<div class="text-center mt-2"><a href="https://rumicare.bibigadgets.com/user-login-form/" class="btn btn-primary" style="color:white">Login to Continue</a></div>';
        exit;
    }

    $user_id = intval($_SESSION['user_id']);
    $job_id = intval($_GET['job_id'] ?? 0);

    // ✅ Check profile
    $profile_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM user_profiles WHERE user_id = %d", $user_id));
    if ($profile_count == 0) {
        echo '<div class="alert alert-warning text-center mt-3">Please complete your profile before applying for this job.</div>';
        echo '<div class="text-center mt-2"><a href="https://rumicare.bibigadgets.com/registration-page/" class="btn btn-primary" style="color:white">Complete Profile</a></div>';
        exit;
    }

    // ✅ Fetch data
    $user = $wpdb->get_row($wpdb->prepare("
        SELECT ui.username, ui.email, ui.contact,
               up.birthdate, up.city, up.bio, up.skills, up.image
        FROM user_info AS ui
        LEFT JOIN user_profiles AS up ON ui.id = up.user_id
        WHERE ui.id = %d
    ", $user_id));

    if (!$user) {
        echo '<div class="alert alert-danger text-center">User profile not found.</div>';
        exit;
    }

    $education = $wpdb->get_results($wpdb->prepare("SELECT * FROM user_education WHERE user_id = %d ORDER BY completion_date DESC", $user_id));
    $experience = $wpdb->get_results($wpdb->prepare("SELECT * FROM user_experience WHERE user_id = %d ORDER BY start_date DESC", $user_id));

    // ✅ Begin UI
    echo '<input type="hidden" id="applyUserId" value="' . esc_attr($user_id) . '">';
    echo '<input type="hidden" id="applyJobId" value="' . esc_attr($job_id) . '">';

    echo '<div class="container mt-3" style="font-family:\'League Spartan\', sans-serif;">';
    echo '<div class="page-wrap">';

    // Header layout
    echo '<div style="display:flex;align-items:center;gap:20px;">';
    if (!empty($user->image)) {
        echo '<img src="https://rumicare.bibigadgets.com/wp-content/themes/onum/page-templates/uploads/' . esc_attr($user->image) . '" alt="Profile Picture" class="profile-img" style="width:90px;height:90px;border-radius:50%;border:3px solid #fc3c68;object-fit:cover;">';
    } else {
        echo '<img src="https://rumicare.bibigadgets.com/wp-content/themes/onum/page-templates/uploads/default.png" alt="Profile Picture" class="profile-img" style="width:90px;height:90px;border-radius:50%;border:3px solid #fc3c68;object-fit:cover;">';
    }

    echo '<div>';
    echo '<h4 class="user-name" style="color:#fc3c68;font-weight:700;margin-bottom:8px;">' . esc_html($user->username) . '</h4>';
    echo '<p style="margin:0;"><strong>Email:</strong> ' . esc_html($user->email) . '</p>';
    echo '<p style="margin:0;"><strong>Contact:</strong> ' . esc_html($user->contact) . '</p>';
    echo '<p style="margin:0;"><strong>City:</strong> ' . esc_html($user->city) . '</p>';
    echo '</div>';
    echo '</div>';

    echo '<hr>';

    // Bio + Skills
    echo '<div style="margin-top:10px;">';
    echo '<h6 class="section-title" style="font-size:13px;font-weight:600;color:#333;">Bio</h6>';
    echo '<p>' . nl2br(esc_html($user->bio)) . '</p>';

    echo '<h6 class="section-title" style="font-size:13px;font-weight:600;color:#333;">Skills</h6>';
    echo '<p>' . nl2br(esc_html($user->skills)) . '</p>';
    echo '</div>';

    // Education
    if (!empty($education)) {
        echo '<div style="margin-top:10px;">';
        echo '<h6 class="section-title" style="font-size:13px;font-weight:600;color:#333;">Education</h6>';
        echo '<ul>';
        foreach ($education as $edu) {
            echo '<li><strong>' . esc_html($edu->course) . '</strong> — ' . esc_html($edu->institute) . ' (' . esc_html($edu->completion_date) . ')</li>';
        }
        echo '</ul>';
        echo '</div>';
    }

    // Experience
    if (!empty($experience)) {
        echo '<div style="margin-top:10px;">';
        echo '<h6 class="section-title" style="font-size:13px;font-weight:600;color:#333;">Experience</h6>';
        foreach ($experience as $exp) {
            $end = $exp->end_date ? esc_html($exp->end_date) : 'Present';
            echo '<div style="margin-bottom:8px;">';
            echo '<strong>' . esc_html($exp->job_designation) . '</strong> — ' . esc_html($exp->company_name) . '<br>';
            echo '<small>Period: ' . esc_html($exp->start_date) . ' to ' . $end . '</small>';
            if (!empty($exp->work_responsibilities)) {
                echo '<p>Responsibilities: ' . nl2br(esc_html($exp->work_responsibilities)) . '</p>';
            }
            echo '</div>';
        }
        echo '</div>';
    }

    echo '<div class="mt-3">';
    echo '<p><strong>Are you sure you want to apply for this job?</strong></p>';
    echo '</div>';

    echo '</div>'; // end page-wrap
    echo '</div>'; // end container
    exit;
}


/**
 * ==========================================================
 *  SUBMIT JOB APPLICATION (FIXED)
 * ==========================================================
 */
if ($action === 'submit_job_application') {
    if (!isset($_SESSION['user_id'])) {
        echo '<pre>❌ Please login first to apply.</pre>';
        exit;
    }

    $user_id = intval($_POST['user_id'] ?? 0);
    $job_id  = intval($_POST['job_id'] ?? 0);

    // ✅ Check if user has a valid profile (linked by user_id)
    $profile_id = $wpdb->get_var($wpdb->prepare(
        "SELECT id FROM user_profiles WHERE user_id = %d",
        $user_id
    ));

    if (!$profile_id) {
        echo '<pre>❌ Please complete your profile before applying for this job.</pre>';
        exit;
    }

    // ✅ Check for duplicate applications
    $exists = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM job_applications WHERE user_id = %d AND job_id = %d",
        $user_id, $job_id
    ));

    if ($exists > 0) {
        echo '⚠️ You have already applied for this job.';
        exit;
    }

    // ✅ Insert job application
    $inserted = $wpdb->insert(
        'job_applications',
        [
            'user_id'    => $user_id,
            'job_id'     => $job_id,
            'applied_on' => current_time('mysql')
        ],
        ['%d', '%d', '%s']
    );

    if ($inserted === false) {
        echo '❌ Something went wrong while submitting. Please try again.';
//         echo '<pre>❌ Something went wrong while submitting. Please try again.
// DB Error: ' . esc_html($wpdb->last_error) . '
// User ID: ' . $user_id . '
// Profile ID: ' . $profile_id . '
// Job ID: ' . $job_id . '</pre>';
    } else {
        echo '✅ Job application submitted successfully!';
    }

    exit;
}


// Default fallback
echo 'Invalid request.';
exit;
?>
