<?php
/**
 * Template Name: On-Farm Training Form
 */
get_header();

global $wpdb;

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['onfarm_submit'])) {

    $table_name = 'wp_onfarm_applications';

    $name        = sanitize_text_field($_POST['farmer_name']);
    $whatsapp    = sanitize_text_field($_POST['whatsapp_no']);
    $email       = sanitize_email($_POST['email']);
    $city       = sanitize_text_field($_POST['city']);
    $address    = sanitize_text_field($_POST['address']);
    $farm_name   = sanitize_text_field($_POST['farm_name']);
    $total_anim  = intval($_POST['total_animals']);
    $training_on = sanitize_text_field($_POST['training_on']);

    // ✅ Check if email already exists (only if not empty)
    if (!empty($email)) {
        $exists = $wpdb->get_var(
            $wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE email = %s", $email)
        );

        if ($exists > 0) {
            echo "<script>
                    alert('❌ You have already applied for On-Farm Training. Our Team Shortly will contact with you soon');                   window.location.href = 'https://rumicare.bibigadgets.com/rumi-training/';
                  </script>";
            exit;
        }
    }

    // ✅ Save data to database
    $inserted = $wpdb->insert($table_name, [
        'farmer_name'   => $name,
        'whatsapp_no'   => $whatsapp,
        'email'         => $email,
         'city'         => $city,
          'address'         => $address,
        'farm_name'     => $farm_name,
        'total_animals' => $total_anim,
        'training_on'   => $training_on,
        'applied_on'    => current_time('mysql'),
    ]);

    if ($inserted) {
        echo "<script>
                alert('✅ Application submitted successfully!');
                window.location.href = 'https://rumicare.bibigadgets.com/rumi-training/';
              </script>";
        exit;
    } else {
        echo '<div style="color:red;padding:10px;border:1px solid red;border-radius:6px;margin:10px 0;">❌ Error: ' . esc_html($wpdb->last_error) . '</div>';
    }
}
?>

<div class="onfarm-container">
  <h2>On-Farm Training Application Form</h2>
  <form method="POST" class="onfarm-form">
    
    <label>Name of Farmer <span>*</span></label>
    <input type="text" name="farmer_name" required>

    <label>WhatsApp Number <span>*</span></label>
    <input type="text" name="whatsapp_no" required>

    <label>Email (Optional)</label>
    <input type="email" name="email">

    <div class="form-row">
      <div class="form-group">
        <label>City <span>*</span></label>
        <input type="text" name="city" required>
      </div>

      <div class="form-group">
        <label>Address <span>*</span></label>
        <input type="text" name="address" required>
      </div>
    </div>
   
   
    <div class="form-row">
      <div class="form-group">
        <label>Farm Name <span>*</span></label>
        <input type="text" name="farm_name" required>
      </div>

      <div class="form-group">
        <label>Total Animals <span>*</span></label>
        <input type="number" name="total_animals" required>
      </div>
    </div>

    <label>Training On <span>*</span></label>
    <select name="training_on" required>
      <option value="">Select Training Type</option>
      <option value="Nutrition & TMR">Nutrition & TMR</option>
      <option value="Health & Breeding">Health & Breeding</option>
      <option value="Hoof trimming & General Management">Hoof trimming & General Management</option>
    </select>

    <button type="submit" name="onfarm_submit">Submit Application</button>
  </form>
</div>
<style>
.onfarm-container {
  width: 90%;
  max-width: 600px;
  margin: 40px auto;
  background: #fff;
  padding: 25px 30px;
  border-radius: 10px;
  box-shadow: rgba(0, 0, 0, 0.1) 0 4px 10px;
  font-family: "League Spartan", Sans-serif;
}

.onfarm-container h2 {
  text-align: center;
  margin-bottom: 20px;
  font-weight: 600;
  color: #333;
  font-size: 2rem;
}

.onfarm-form label {
  display: block;
  margin-top: 12px;
  font-weight: 500;
  color: #444;
  font-size: 16px;
}

.onfarm-form input{
      padding: 5px;

}
.onfarm-form input,
.onfarm-form select,
.onfarm-form textarea {
  width: 100%;
  border: 1px solid #ccc;
  border-radius: 6px;
  margin-top: 5px;
  font-size: 16px;
  box-sizing: border-box;
}


.onfarm-form select,
.onfarm-form textarea {
 
  padding: 10px;
}

/* ✅ Always keep two fields in one line */
.onfarm-form .form-row {
  display: flex;
  justify-content: space-between;
  gap: 10px;
  flex-wrap: nowrap; /* prevents stacking */
}

.onfarm-form .form-row .form-group {
  width: 50%;
}

.onfarm-form button {
  width: 100%;
  margin-top: 20px;
  padding: 10px;
  background: #007bff;
  border: none;
  color: #fff;
  border-radius: 6px;
  font-weight: 600;
  cursor: pointer;
  transition: background 0.3s;
  font-size: 14px;
}

.onfarm-form button:hover {
  background: #0056b3;
}

.onfarm-form span {
  color: red;
}


</style>


<?php get_footer(); ?>
