<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once dirname(__FILE__, 4) . '/wp-load.php';
global $wpdb;

$table_name = 'orders';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    wp_die('Invalid request');
}

$product_id   = intval($_POST['product_id'] ?? 0);
$product_name = sanitize_text_field($_POST['product_name'] ?? '');
$price        = floatval($_POST['price'] ?? 0);
$name         = sanitize_text_field($_POST['name'] ?? '');
$email        = sanitize_email($_POST['email'] ?? '');
$contact      = sanitize_text_field($_POST['contact'] ?? '');
$address      = sanitize_textarea_field($_POST['address'] ?? '');

if (!$product_id || !$name || !$contact) {
    wp_send_json_error('Missing required fields');
}

$inserted = $wpdb->insert(
    $table_name,
    [
        'product_id'   => $product_id,
        'product_name' => $product_name,
        'price'        => $price,
        'name'         => $name,
        'email'        => $email,
        'contact'      => $contact,
        'address'      => $address,
        'created_at'   => current_time('mysql')
    ]
);

if ($inserted) {
    wp_send_json_success('Order saved');
} else {
    wp_send_json_error($wpdb->last_error);
}
