<?php
/**
 * Template Name: Product Upload Template
 * Description: Frontend product upload form (image preview + clean UI)
 */
get_header();
?>

<style>
.product-form-container {
  width: 90%;
  max-width: 650px;
  margin: 50px auto;
  background: #fff;
  padding: 30px 35px;
  border-radius: 12px;
  box-shadow: rgba(0, 0, 0, 0.1) 0 4px 10px;
  font-family: "Poppins", sans-serif;
}

.product-form-container h2 {
  text-align: center;
  margin-bottom: 25px;
  font-weight: 600;
  color: #333;
  font-size: 2rem;
}

/* Image preview area */
.image-upload-section {
  display: flex;
  align-items: end;
  gap: 15px;
  margin-bottom: 15px;
}

.image-upload-box {
  width: 120px;
  height: 120px;
  border: 2px dashed #ccc;
  border-radius: 10px;
  display: flex;
  justify-content: center;
  align-items: center;
  overflow: hidden;
  background: #f9f9f9;
  transition: 0.3s ease;
  cursor: pointer;
}
.image-upload-box:hover {
  border-color: #007bff;
}
.image-upload-box img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

.upload-btn {
  background: #007bff;
  color: #fff;
  border: none;
  border-radius: 6px;
  padding: 10px 20px;
  cursor: pointer;
  font-size: 14px;
  font-weight: 600;
  transition: 0.3s;
}
.upload-btn:hover {
  background: #0056b3;
}
.hidden-file-input {
  display: none;
}

/* Input & textarea styling */
.product-form-container input[type="text"],
.product-form-container input[type="number"],
.product-form-container select,
.product-form-container textarea {
  width: 100%;
  padding: 10px;
  margin-bottom: 8px;
  border: 1px solid #ccc;
  border-radius: 6px;
  font-size: 1rem;
  box-sizing: border-box;
  transition: 0.2s;
}
.product-form-container input:focus,
.product-form-container textarea:focus,
.product-form-container select:focus {
  border-color: #007bff;
  outline: none;
}

div, h1, h2, h3, h4, h5, h6, p, span, ul, li, a {
    font-family: "League Spartan", Sans-serif !important;
}

/* Two-column row */
.form-row {
  display: flex;
  flex-wrap: wrap;
  gap: 15px;
}
.form-group {
  flex: 1 1 48%;
}

/* Submit button */
button.submit-btn {
  width: 100%;
  margin-top: 25px;
  padding: 12px;
  background: #007bff;
  border: none;
  color: #fff;
  border-radius: 6px;
  font-weight: 600;
  cursor: pointer;
  transition: background 0.3s;
  font-size: 1.1rem;
}
button.submit-btn:hover {
  background: #0056b3;
}

label{
    margin-top:10px;
}

@media (max-width: 600px) {
  .form-row {
    flex-direction: column;
  }
  .image-upload-section {
    flex-direction: column;
    align-items: flex-start;
  }
}
</style>

<div class="product-form-container">
  <h2>Post a Product</h2>

  <form method="post" enctype="multipart/form-data" action="<?php echo esc_url(get_template_directory_uri() . '/page-templates/page-product-submit.php'); ?>" >
    
    <label>Product Image</label>
    <div class="image-upload-section">
      <div class="image-upload-box" id="imagePreviewBox">
        <img id="previewImage" src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/10/2ewdszx.png" alt="Preview">
        <input type="file" name="product_image" id="productImageInput" accept="image/*" class="hidden-file-input" required>
      </div>
      <button type="button" class="upload-btn" onclick="document.getElementById('productImageInput').click();">Upload Image</button>
    </div>

    <label>Product Title</label>
    <input type="text" name="title" placeholder="Enter product title" required>

    <label>Price</label>
    <input type="number" name="price" step="0.01" placeholder="Enter product price" required>

     <label>Short Description</label>
        <textarea name="short_description" rows="1" placeholder="Enter Short product description..." required></textarea>
        
    <label>Description</label>
    <textarea name="description" rows="4" placeholder="Enter product description..." required></textarea>

    <label>Category</label>
    <select name="category" required>
      <option value="">-- Select Category --</option>
      <option value="Nutritional-Products">Nutritional Products</option>
      <option value="Dairy-Equipment">Dairy Equipment</option>
      <option value="Pharmaceutical">Pharmaceutical Products</option>
    </select>

    <div class="form-row">
      <div class="form-group">
        <label>Seller Name</label>
        <input type="text" name="seller_name" placeholder="Enter seller name" required>
      </div>
      <div class="form-group">
        <label>Quantity</label>
        <input type="number" name="quantity" placeholder="Enter quantity" required>
      </div>
    </div>

    <button type="submit" name="submit_product" class="submit-btn">Submit Product</button>
  </form>
</div>

<script>
// ✅ Live image preview
document.getElementById('productImageInput').addEventListener('change', function(event) {
  const file = event.target.files[0];
  if (file) {
    const reader = new FileReader();
    reader.onload = function(e) {
      document.getElementById('previewImage').src = e.target.result;
    };
    reader.readAsDataURL(file);
  }
});
</script>

<?php get_footer(); ?>
