<?php
// ==== START SESSION ====
session_start();

// ==== DATABASE CONFIGURATION ====
$servername = "localhost";
$username   = "bibigadg_wp_snqtv";
$password   = "Uu%aiqPE?6het28_";
$dbname     = "bibigadg_wp_gecpv";

// ==== CONNECT DATABASE ====
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Database Connection failed: " . $conn->connect_error);
}

// ==== VERIFY LOGIN ====
if (!isset($_SESSION['user_id']) || empty($_SESSION['user_id'])) {
    echo "<script>
            alert('You must be logged in to submit the form.');
            window.location.href='https://rumicare.bibigadgets.com/';
          </script>";
    exit;
}

$user_id = intval($_SESSION['user_id']);

// ==== COLLECT FORM DATA ====
$birthdate = $_POST['birthdate'] ?? '';
$city      = $_POST['city'] ?? '';
$bio       = $_POST['bio'] ?? '';
$skillsArr = $_POST['skills'] ?? [];
$skills    = implode(', ', $skillsArr);


// ==== IMAGE UPLOAD HANDLER (BASE64 CROPPED IMAGE) ====
$imageFileName = '';

if (!empty($_POST['profile_image'])) {

    $base64Image = $_POST['profile_image'];

    // remove base64 header
    $base64Image = str_replace('data:image/png;base64,', '', $base64Image);
    $base64Image = str_replace(' ', '+', $base64Image);

    // decode
    $decodedImage = base64_decode($base64Image);

    // upload directory
    $uploadDir = $_SERVER['DOCUMENT_ROOT'] . '/wp-content/themes/onum/page-templates/uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // filename
    $imageFileName = "profile_" . $user_id . "_" . time() . ".png";
    $filePath = $uploadDir . $imageFileName;

    // save file
    file_put_contents($filePath, $decodedImage);
}


// ==== INSERT INTO user_profiles ====
$sql_profile = "
    INSERT INTO user_profiles (user_id, birthdate, city, bio, skills, image, created_at)
    VALUES (?, ?, ?, ?, ?, ?, NOW())
";
$stmt = $conn->prepare($sql_profile);
$stmt->bind_param("isssss", $user_id, $birthdate, $city, $bio, $skills, $imageFileName);

if ($stmt->execute()) {
    $profile_id = $stmt->insert_id;
    // echo "<p>✅ Profile created successfully (ID: $profile_id)</p>";
} else {
    die("❌ Profile Error: " . $conn->error);
}
$stmt->close();

// ==== INSERT INTO user_education ====
if (!empty($_POST['course'])) {
    $sql_edu = "
        INSERT INTO user_education (user_id, course, institute, completion_date)
        VALUES (?, ?, ?, ?)
    ";
    $stmtEdu = $conn->prepare($sql_edu);

    foreach ($_POST['course'] as $index => $course) {
        $institute = $_POST['institute'][$index] ?? '';
        $completion_date = $_POST['year'][$index] ?? '';

        if (!empty($course) && !empty($institute)) {
            $stmtEdu->bind_param("isss", $user_id, $course, $institute, $completion_date);
            if (!$stmtEdu->execute()) {
                echo "<p>❌ Education Error: " . $conn->error . "</p>";
            }
        }
    }
    $stmtEdu->close();
    // echo "<p>✅ Education records saved successfully.</p>";
}

// ==== INSERT INTO user_experience ====
if (!empty($_POST['company_name'])) {
    $sql_exp = "
        INSERT INTO user_experience (user_id, company_name, job_designation, start_date, end_date, work_responsibilities)
        VALUES (?, ?, ?, ?, ?, ?)
    ";
    $stmtExp = $conn->prepare($sql_exp);

    foreach ($_POST['company_name'] as $index => $company_name) {
        $job_designation = $_POST['job_designation'][$index] ?? '';
        $start_date = $_POST['start_date'][$index] ?? '';
        $end_date   = $_POST['end_date'][$index] ?? '';
        $work_responsibilities = $_POST['work_responsibilities'][$index] ?? '';

        if (!empty($company_name) && !empty($job_designation)) {
            $stmtExp->bind_param("isssss", $user_id, $company_name, $job_designation, $start_date, $end_date, $work_responsibilities);
            if (!$stmtExp->execute()) {
                echo "<p>❌ Experience Error: " . $conn->error . "</p>";
            }
        }
    }
    $stmtExp->close();
    // echo "<p>✅ Work experience saved successfully.</p>";
}

// ==== SUCCESS MESSAGE ====
echo "<script>
        alert('Profile created successfully!');
        window.location.href='https://rumicare.bibigadgets.com/user-detail-page/?id=$user_id';
      </script>";

$conn->close();
?>
