<?php
/**
 * Template Name: Super Dashboard Admin
 */
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');
global $wpdb;

session_start(); // Start session

// Check if Super Admin is logged in via session
if (!isset($_SESSION['super_admin_id'])) {
    wp_redirect(home_url("/super-admin"));
    exit;
}

// Table names
$user_table   = 'user_info';
$farmer_table = 'farmers_info';
$jobs_table   = 'farm_jobs';
$training_table = 'wp_onfarm_applications';
$group_table = 'wp_group_farm_applications'; // NEW
$online_table = 'wp_online_farm_traning_applications';
$products_table  = 'rumicare_products'; // ✅ Added products table



// Remove these lines
$orders_table = 'rumicare_orders';
$abandoned_table = 'rumicare_abandoned_orders';


// ✅ DELETE logic
if (isset($_GET['delete_user'])) {
    $id = intval($_GET['delete_user']);
    $wpdb->delete($user_table, ['id' => $id]);
    echo "<script>alert('User deleted successfully!'); window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';</script>";
    exit;
}
if (isset($_GET['delete_farmer'])) {
    $id = intval($_GET['delete_farmer']);
    $wpdb->delete($farmer_table, ['id' => $id]);
    echo "<script>alert('Farmer deleted successfully!'); window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';</script>";
    exit;
}
if (isset($_GET['delete_job'])) {
    $id = intval($_GET['delete_job']);
    $wpdb->delete($jobs_table, ['id' => $id]);
    echo "<script>alert('Job deleted successfully!'); window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';</script>";
    exit;
}

// ✅ DELETE logic
if (isset($_GET['delete_training'])) {
    $id = intval($_GET['delete_training']);
    $wpdb->delete($training_table, ['id' => $id]);
    echo "<script>alert('Training application deleted successfully!'); window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';</script>";
    exit;
}

// NEW: delete group training handler
if (isset($_GET['delete_group_training'])) {
    $id = intval($_GET['delete_group_training']);
    $wpdb->delete($group_table, ['id' => $id]);
    echo "<script>alert('Group training application deleted successfully!'); window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';</script>";
    exit;
}

// NEW: delete online training handler
if (isset($_GET['delete_online_training'])) {
    $id = intval($_GET['delete_online_training']);
    $wpdb->delete($online_table, ['id' => $id]);
    echo "<script>
            alert('Online training application deleted successfully!');
            window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';
          </script>";
    exit;
}


if (isset($_GET['delete_product'])) {
    $wpdb->delete($products_table, ['id' => intval($_GET['delete_product'])]);
    echo "<script>alert('Product deleted successfully!'); window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';</script>"; exit;
}


if (isset($_GET['delete_order'])) {
    $id = intval($_GET['delete_order']);
    $wpdb->delete($orders_table, ['id' => $id], ['%d']); // %d ensures it's treated as integer
    echo "<script>
            alert('Order deleted successfully!');
            window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';
          </script>";
    exit;
}

if (isset($_GET['delete_abandoned_order'])) {
    $id = intval($_GET['delete_abandoned_order']);
    $wpdb->delete($abandoned_table, ['id' => $id], ['%d']);
    echo "<script>
            alert('Abandoned order deleted successfully!');
            window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';
          </script>";
    exit;
}

if (isset($_GET['delete_blog'])) {
    $post_id = intval($_GET['delete_blog']);
    wp_delete_post($post_id, true);

    echo "<script>
            alert('Blog deleted successfully!');
            window.location.href='" . esc_url(site_url('/super-admin-dashboard')) . "';
          </script>";
    exit;
}





// ✅ Fetch data
$all_users   = $wpdb->get_results("SELECT * FROM {$user_table} ORDER BY id DESC");
$all_farmers = $wpdb->get_results("SELECT * FROM {$farmer_table} ORDER BY id DESC");
$all_jobs    = $wpdb->get_results("SELECT * FROM {$jobs_table} ORDER BY id DESC");
$all_trainings  = $wpdb->get_results("SELECT * FROM {$training_table} ORDER BY id DESC");
$all_groups = $wpdb->get_results("SELECT * FROM {$group_table} ORDER BY id DESC"); // NEW
$all_online = $wpdb->get_results("SELECT * FROM {$online_table} ORDER BY id DESC"); // NEW
$all_products   = $wpdb->get_results("SELECT * FROM {$products_table} ORDER BY id DESC"); // ✅ Products


$args = array(
    'post_type'      => 'post',
    'post_status'    => 'publish',
    'posts_per_page' => -1,
    'orderby'        => 'date',
    'order'          => 'DESC'
);

$all_blogs = get_posts($args);


?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Super Admin Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #f5f6fa;
    display: flex;
    min-height: 100vh;
}
/*.sidebar {*/
/*    width: 250px;*/
/*    background: #1e293b;*/
/*    color: white;*/
/*    position: fixed;*/
/*    top: 0;*/
/*    bottom: 0;*/
/*    left: 0;*/
/*    padding-top: 30px;*/
/*    display: flex;*/
/*    flex-direction: column;*/
/*}*/

.sidebar {
    width: 250px;
    background: #1e293b;
    color: white;
    position: fixed;
    top: 0;
    bottom: 0;
    left: 0;
    padding-top: 30px;
    display: flex;
    flex-direction: column;
    height: 100vh;          /* ensures full viewport height */
    overflow-y: auto;       /* makes it scrollable if content overflows */
     scroll-behavior: smooth;
}

.sidebar h3 {
    text-align: center;
    margin-bottom: 20px;
    font-weight: 600;
}
.sidebar a {
    padding: 14px 25px;
    text-decoration: none;
    color: #cbd5e1;
    display: block;
    transition: 0.3s;
    font-weight: 500;
}
.sidebar a:hover, .sidebar a.active {
    background: #0ea5e9;
    color: #fff;
}
.main-content {
    margin-left: 250px;
    flex: 1;
    padding: 30px;
}
.topbar {
    background: #fff;
    border-radius: 8px;
    padding: 15px 25px;
    margin-bottom: 25px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}
.data-table {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    padding: 20px;
}
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 15px;
}
table th, table td {
    padding: 10px 15px;
    border-bottom: 1px solid #eee;
    font-size: 14px;
    vertical-align: middle;
}
table th {
    background: #f1f5f9;
    font-weight: 600;
}
tr:hover {
    background-color: #f9fafb;
}
.search-box {
    display: flex;
    justify-content: flex-end;
    align-items: center;
    margin-bottom: 10px;
}
.search-box input {
    width: 250px;
    border: 1px solid #ddd;
    border-radius: 20px;
    padding: 8px 15px;
    font-size: 14px;
    outline: none;
    transition: 0.3s;
}
.search-box input:focus {
    border-color: #0ea5e9;
    box-shadow: 0 0 0 3px rgba(14,165,233,0.2);
}
.action-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    font-size: 13px;
    padding: 5px 10px;
    border-radius: 6px;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}
.action-view { background: #3b82f6; color: #fff; }
.action-edit { background: #10b981; color: #fff; }
.action-delete { background: #ef4444; color: #fff; }
.action-btn:hover { opacity: 0.85; }
.product-img { width: 60px; height: 60px; object-fit: cover; border-radius: 8px; }
.admin-img{
  width: 70% !important;
  margin-left:20px;
  text-align:center;
}
.admin-img img {
    margin-bottom:2px;
    width: 56%;
    border-radius: 400px;
    height: 90px;
}
.admin-img p {
        text-transform: capitalize;
}

</style>

<script>
/* ================= MOBILE MENU ================= */
function toggleMobileMenu() {
    const menu = document.getElementById('mobileMenu');
    if (!menu) return;

    menu.style.display = menu.style.display === 'block' ? 'none' : 'block';
}

/* ================= SECTION SWITCHER ================= */
function showSection(section, el = null) {

    // hide all sections
    document.querySelectorAll('.section').forEach(div => {
        div.style.display = 'none';
    });

    // show selected section
    const target = document.getElementById(section);
    if (target) {
        target.style.display = 'block';
    }

    // remove active state from ALL menus
    document.querySelectorAll('.sidebar a, .mobile-menu a').forEach(a => {
        a.classList.remove('active');
    });

    // activate clicked menu item
    if (el) {
        el.classList.add('active');
    }

    // close mobile menu after click
    const mobileMenu = document.getElementById('mobileMenu');
    if (mobileMenu) {
        mobileMenu.style.display = 'none';
    }
}

/* ================= SEARCH FILTER ================= */
function searchTable(inputId, tableId) {
    const input = document.getElementById(inputId);
    const filter = input.value.toLowerCase();
    const table = document.getElementById(tableId);
    if (!table) return;

    const rows = table.getElementsByTagName('tr');

    for (let i = 1; i < rows.length; i++) {
        const cells = rows[i].getElementsByTagName('td');
        let match = false;

        for (let j = 0; j < cells.length; j++) {
            if (cells[j] && cells[j].innerText.toLowerCase().includes(filter)) {
                match = true;
                break;
            }
        }
        rows[i].style.display = match ? '' : 'none';
    }
}

/* ================= DEFAULT SECTION ================= */
document.addEventListener('DOMContentLoaded', function () {
    const defaultSection = document.getElementById('users');
    if (defaultSection) {
        defaultSection.style.display = 'block';
    }
});
</script>
<style>
    /* Desktop default */
.desktop-menu {
    display: block;
}
.mobile-topbar,
.mobile-menu {
    display: none;
}

/* Mobile view */
@media (max-width: 768px) {
    .desktop-menu {
        display: none;
    }

    .mobile-topbar {
        display: flex;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        height: 60px;
        background: #1e293b;
        color: #fff;
        padding: 0 15px;
        align-items: center;
        justify-content: space-between;
        z-index: 2000;
    }

    .mobile-menu {
        display: none;
        position: fixed;
        top: 60px;
        left: 0;
        right: 0;
        background: #1e293b;
        z-index: 1900;
    }

    .mobile-menu a {
        display: block;
        padding: 12px 20px;
        color: #cbd5e1 !important;
        border-bottom: 1px solid rgba(255,255,255,0.1);
    }

    .mobile-menu a:hover {
        background: #0ea5e9;
        color: #fff;
    }

    .main-content {
        margin-left: 0;
        padding-top: 80px;
    }
}

</style>




</head>

<body>

<!-- Mobile Topbar -->
<div class="mobile-topbar">
    <span>Super Admin</span>
    <div class="hamburger" onclick="toggleMobileMenu()">
        ☰
    </div>
</div>

<!-- Mobile Dropdown Menu -->
<div class="mobile-menu" id="mobileMenu">
    <a onclick="showSection('users', this)">All Users</a>
    <a onclick="showSection('farmers', this)">All Farmers</a>
    <a onclick="showSection('jobs', this)">All Jobs</a>
    <a onclick="showSection('training', this)">On Farm Applications</a>
    <a onclick="showSection('groupTraining', this)">Group Training</a>
    <a onclick="showSection('onlineTraining', this)">Online Training</a>
    <a onclick="showSection('products', this)">All Products</a>
    <a onclick="showSection('orders', this)">Rumicare Orders</a>
    <a onclick="showSection('abandonedOrders', this)">Abandoned Orders</a>

    <a href="<?= site_url('/product-upload') ?>" target="_blank">Add Product</a>
    
    <a onclick="window.location.href='<?= site_url('/add-blog') ?>'">Add Blog</a>
    <a onclick="showSection('blogs', this)">All Blogs</a>
</div>



<!-- Sidebar -->
<div class="sidebar desktop-menu">
    <h3>Super Admin</h3>
    <div class="admin-img">
<img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/10/3wresdxzc.png" alt="Admin Profile">
<p><?= isset($_SESSION['super_admin_name']) ? esc_html($_SESSION['super_admin_name']) : 'Super Admin'; ?></p>
</div>


    

        <a href="#users" class="active" onclick="showSection('users', this)">All Users</a>
        <a href="#all-farmers" onclick="showSection('farmers', this)">All Farmers</a>
        <a href="#all-jobs" onclick="showSection('jobs', this)" >All Jobs</a>
        <a href="#on-farm-applications" onclick="showSection('training', this)" >On Farm Applications</a>
        <a href="#group-training" onclick="showSection('groupTraining', this)" >Group Training</a>
        <a href="#online-training" onclick="showSection('onlineTraining', this)" >Online Training</a>
        <a href="#all-products" onclick="showSection('products', this)" >All Products</a>
        
        <a href="#rumi-orders" onclick="showSection('orders', this)" >Rumicare Orders</a>
        <a href="#abandoned-orders" onclick="showSection('abandonedOrders', this)" >Abandoned Orders</a>
        
        <a href="<?= site_url('/product-upload') ?>" target="_blank">Add Product</a>
        <a href="#add-blog" onclick="window.location.href='<?= site_url('/add-blog') ?>'">Add Blog</a>
        <a href="#blogs" onclick="showSection('blogs', this)">All Blogs</a>


    
    <!-- ✅ Add Product -->

</div>

<!-- Main Content -->
<div class="main-content">
    <div class="topbar">
        <h4>Dashboard Overview</h4>
    </div>

    <!-- All Users -->
    <div class="data-table section" id="users" style="display:block;">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5>All Users</h5>
            <div class="search-box">
                <input type="text" id="searchUsers" onkeyup="searchTable('searchUsers','usersTable')" placeholder="Search users...">
            </div>
        </div>
        <table id="usersTable">
            <tr>
                <th>ID</th><th>Username</th><th>Email</th><th>Contact</th><th>Action</th>
            </tr>
            <?php foreach ($all_users as $user): ?>
            <tr>
                <td><?= esc_html($user->id) ?></td>
                <td><?= esc_html($user->username) ?></td>
                <td><?= esc_html($user->email) ?></td>
                <td><?= esc_html($user->contact) ?></td>
                <td>
                    <a href="<?=site_url('/super-admin-view-user?id='.$user->id)?>" class="action-btn action-view"><i class="bi bi-eye"></i> View</a>
                    <a href="<?=site_url('/super-admin-edit-user?id='.$user->id)?>" class="action-btn action-edit"><i class="bi bi-pencil"></i> Edit</a>
                    <a href="?delete_user=<?=$user->id?>" class="action-btn action-delete" onclick="return confirm('Delete this user?')"><i class="bi bi-trash"></i> Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>

    <!-- All Farmers -->
    <div class="data-table section" id="farmers" style="display:none;">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5>All Farmers</h5>
            <div class="search-box">
                <input type="text" id="searchFarmers" onkeyup="searchTable('searchFarmers','farmersTable')" placeholder="Search farmers...">
            </div>
        </div>
        <table id="farmersTable">
            <tr>
                <th>ID</th><th>Full Name</th><th>Email</th><th>Contact</th><th>Action</th>
            </tr>
            <?php foreach ($all_farmers as $farmer): ?>
            <tr>
                <td><?= esc_html($farmer->id) ?></td>
                <td><?= esc_html($farmer->full_name) ?></td>
                <td><?= esc_html($farmer->email) ?></td>
                <td><?= esc_html($farmer->contact) ?></td>
                <td>
                    <a href="<?=site_url('/super-admin-view-farmer?id='.$farmer->id)?>" class="action-btn action-view"><i class="bi bi-eye"></i> View</a>
                    <a href="<?=site_url('/super-admin-edit-farmer?id='.$farmer->id)?>" class="action-btn action-edit"><i class="bi bi-pencil"></i> Edit</a>
                    <a href="?delete_farmer=<?=$farmer->id?>" class="action-btn action-delete" onclick="return confirm('Delete this farmer?')"><i class="bi bi-trash"></i> Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>




    <!-- All Jobs -->
    <div class="data-table section" id="jobs" style="display:none;">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5>All Jobs</h5>
            <div class="search-box">
                <input type="text" id="searchJobs" onkeyup="searchTable('searchJobs','jobsTable')" placeholder="Search jobs...">
            </div>
        </div>
        <table id="jobsTable">
            <tr>
                <th>ID</th><th>Farm Name</th><th>Role</th><th>City</th><th>Salary</th><th>Status</th><th>Action</th>
            </tr>
            <?php foreach ($all_jobs as $job): ?>
            <tr>
                <td><?= esc_html($job->id) ?></td>
                <td><?= esc_html($job->farm_name) ?></td>
                <td><?= esc_html($job->role) ?></td>
                <td><?= esc_html($job->city) ?></td>
                <td><?= esc_html($job->salary_package) ?></td>
                <td><?= esc_html($job->status) ?></td>
                <td>
                    <a href="<?=site_url('/super-admin-view-job?id='.$job->id)?>" class="action-btn action-view"><i class="bi bi-eye"></i> View</a>
                    <a href="<?=site_url('/super-admin-edit-job?id='.$job->id)?>" class="action-btn action-edit"><i class="bi bi-pencil"></i> Edit</a>
                    <a href="?delete_job=<?=$job->id?>" class="action-btn action-delete" onclick="return confirm('Delete this job?')"><i class="bi bi-trash"></i> Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
    
    
     <!-- ✅ New Section: On Farm Applications -->
    <div class="data-table section" id="training" style="display:none;">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5>On Farm Training Applications</h5>
            <div class="search-box">
                <input type="text" id="searchTraining" onkeyup="searchTable('searchTraining','trainingTable')" placeholder="Search training applications...">
            </div>
        </div>

        <table id="trainingTable">
            <tr>
                <th>ID</th>
                <th>Farmer Name</th>
                <th>Farm Name</th>
                <th>Total Animals</th>
                <th>Email</th>
                <th>WhatsApp No</th>
                <th>Training On</th>
                <th>Applied On</th>
                <th>Action</th>
            </tr>
            <?php foreach ($all_trainings as $t): ?>
            <tr>
                <td><?= esc_html($t->id) ?></td>
                <td><?= esc_html($t->farmer_name) ?></td>
                <td><?= esc_html($t->farm_name) ?></td>
                <td><?= esc_html($t->total_animals) ?></td>
                <td><?= esc_html($t->email) ?></td>
                <td><?= esc_html($t->whatsapp_no) ?></td>
                <td><?= esc_html($t->training_on) ?></td>
                <td><?= esc_html($t->applied_on) ?></td>
                <td>
                    <a href="?delete_training=<?= $t->id ?>" class="action-btn action-delete" onclick="return confirm('Delete this training application?')">
                        <i class="bi bi-trash"></i> Delete
                    </a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
    
    <!-- ✅ New Section: Group Training Applications -->
    <div class="data-table section" id="groupTraining" style="display:none;">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5>Group Training Applications</h5>
            <div class="search-box">
                <input type="text" id="searchGroupTraining" onkeyup="searchTable('searchGroupTraining','groupTrainingTable')" placeholder="Search group training applications...">
            </div>
        </div>

        <table id="groupTrainingTable">
            <tr>
                 <th>ID</th>
                <th>Apply As</th>
                <th>Candidate Name</th>
                <th>WhatsApp No</th>
                <th>Email</th>
                <th>Farm Name</th>
                <th>Total Animals</th>
                <th>Training On</th>
                <th>Degree</th>
                <th>Completion Year</th>
                <th>City</th>
                <th>Applied On</th>
                <th>Action</th>
            </tr>
            <?php foreach ($all_groups as $g): ?>
            <tr>
                <td><?= esc_html($g->id) ?></td>
                <td><?= esc_html($g->apply_as) ?></td>
                <td><?= esc_html($g->candidate_name) ?></td>
                <td><?= esc_html($g->whatsapp_no) ?></td>
                <td><?= esc_html($g->email) ?></td>
                <td><?= esc_html($g->farm_name) ?></td>
                <td><?= esc_html($g->total_animals) ?></td>
                <td><?= esc_html($g->training_on) ?></td>
                <td><?= esc_html($g->degree_name) ?></td>
                <td><?= esc_html($g->completion_year) ?></td>
                <td><?= esc_html($g->city) ?></td>
                <td><?= esc_html($g->applied_on) ?></td>
                <td>
                    <a href="?delete_group_training=<?= $g->id ?>" class="action-btn action-delete" onclick="return confirm('Delete this group training application?')">
                        <i class="bi bi-trash"></i> Delete
                    </a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
    
    <!-- ✅ New Section: Online Training Applications -->
<div class="data-table section" id="onlineTraining" style="display:none;">
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h5>Online Training Applications</h5>
        <div class="search-box">
            <input type="text" id="searchOnlineTraining" onkeyup="searchTable('searchOnlineTraining','onlineTrainingTable')" placeholder="Search online training applications...">
        </div>
    </div>

    <table id="onlineTrainingTable">
        <tr>
            <th>ID</th>
            <th>Apply As</th>
            <th>Candidate Name</th>
            <th>WhatsApp No</th>
            <th>Email</th>
            <th>Farm Name</th>
            <th>Total Animals</th>
            <th>Training On</th>
            <th>Degree</th>
            <th>Completion Year</th>
            <th>City</th>
            <th>Applied On</th>
            <th>Action</th>
        </tr>

        <?php foreach ($all_online as $t): ?>
        <tr>
            <td><?= esc_html($t->id) ?></td>
            <td><?= esc_html($t->apply_as) ?></td>
            <td><?= esc_html($t->candidate_name) ?></td>
            <td><?= esc_html($t->whatsapp_no) ?></td>
            <td><?= esc_html($t->email) ?></td>
            <td><?= esc_html($t->farm_name) ?></td>
            <td><?= esc_html($t->total_animals) ?></td>
            <td><?= esc_html($t->training_on) ?></td>
            <td><?= esc_html($t->degree_name) ?></td>
            <td><?= esc_html($t->completion_year) ?></td>
            <td><?= esc_html($t->city) ?></td>
            <td><?= esc_html($t->applied_on) ?></td>

            <td>
                <a href="?delete_online_training=<?= $t->id ?>" class="action-btn action-delete" onclick="return confirm('Delete this online training application?')">
                    <i class="bi bi-trash"></i> Delete
                </a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>

    
    
     <!-- ✅ Products Section -->
    <div class="data-table section" id="products" style="display:none;">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5>All Products</h5>
            <div class="search-box">
                <input type="text" id="searchProducts" onkeyup="searchTable('searchProducts','productsTable')" placeholder="Search products...">
            </div>
        </div>
        <table id="productsTable">
            <tr>
                <th>ID</th>
                <th>Image</th>
                <th>Title</th>
                <th>Category</th>
                <th>Seller</th>
                <th>Price</th>
                <th>Quantity</th>
                <th>Action</th>
            </tr>
            <?php foreach ($all_products as $p): ?>
            <tr>
                <td><?= esc_html($p->id) ?></td>
                <td><img src="<?= esc_url(site_url('/wp-content/themes/onum/page-templates/Products-images/' . $p->image)) ?>" class="product-img"></td>
                <td><?= esc_html($p->title) ?></td>
                <td><?= esc_html($p->category) ?></td>
                <td><?= esc_html($p->seller_name) ?></td>
                <td><?= esc_html($p->price) ?></td>
                <td><?= esc_html($p->quantity) ?></td>
                <td>
                    <a href="<?= site_url('/product-detail/?id=' . $p->id) ?>" class="action-btn action-view"><i class="bi bi-eye"></i> View</a>
                    <a href="<?= site_url('/edit-product?id=' . $p->id) ?>" class="action-btn action-edit"><i class="bi bi-pencil"></i> Edit</a>
                    <a href="?delete_product=<?= $p->id ?>" class="action-btn action-delete" onclick="return confirm('Delete this product?')"><i class="bi bi-trash"></i> Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>

    
    <!-- Rumicare Orders Section -->
<div class="data-table section" id="orders" style="display:none;">
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h5>All Orders</h5>
        <div class="search-box">
            <input type="text" id="searchOrders" onkeyup="searchTable('searchOrders','ordersTable')" placeholder="Search orders...">
        </div>
    </div>
    <table id="ordersTable">
        <tr>
            <th>ID</th>
            <th>Product</th>
            <th>Product ID</th>
            <th>Name</th>
            <th>Email</th>
            <th>Contact</th>
            <th>Address</th>
            <th>Price</th>
            <th>Applied On</th>
            <th>Action</th>
        </tr>
        <?php
        $orders_table = 'rumicare_orders'; // Your orders table
        $all_orders = $wpdb->get_results("SELECT * FROM {$orders_table} ORDER BY id DESC");
        foreach ($all_orders as $o): ?>
        <tr>
            <td><?= esc_html($o->id) ?></td>
            <td><?= esc_html($o->product_name) ?></td>
            <td><?= esc_html($o->product_id) ?></td>
            <td><?= esc_html($o->name) ?></td>
            <td><?= esc_html($o->email) ?></td>
            <td><?= esc_html($o->contact) ?></td>
            <td><?= esc_html($o->address) ?></td>
            <td><?= esc_html($o->price) ?></td>
            <td><?= esc_html($o->created_at) ?></td>
            <td>
                <a href="<?= site_url('/product-detail/?id=' . $o->product_id) ?>" target="_blank" class="action-btn action-view">
                    <i class="bi bi-eye"></i> View
                </a>
                <a href="?delete_order=<?= $o->id ?>" class="action-btn action-delete" onclick="return confirm('Delete this order?')">
                    <i class="bi bi-trash"></i> Delete
                </a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>


<!-- Abandoned Orders Section -->
<div class="data-table section" id="abandonedOrders" style="display:none;">
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h5>Abandoned Orders</h5>
        <div class="search-box">
            <input type="text" id="searchAbandonedOrders" onkeyup="searchTable('searchAbandonedOrders','abandonedOrdersTable')" placeholder="Search abandoned orders...">
        </div>
    </div>
    <table id="abandonedOrdersTable">
        <tr>
            <th>ID</th>
            <th>Product</th>
            <th>Product ID</th>
            <th>Name</th>
            <th>Email</th>
            <th>Contact</th>
            <th>Address</th>
            <th>Price</th>
            <th>Applied On</th>
            <th>Action</th>
        </tr>
        <?php
        $abandoned_table = 'rumicare_abandoned_orders'; // Replace with your abandoned orders table
        $all_abandoned = $wpdb->get_results("SELECT * FROM {$abandoned_table} ORDER BY id DESC");
        foreach ($all_abandoned as $a): ?>
        <tr>
            <td><?= esc_html($a->id) ?></td>
            <td><?= esc_html($a->product_name) ?></td>
            <td><?= esc_html($a->product_id) ?></td>
            <td><?= esc_html($a->name) ?></td>
            <td><?= esc_html($a->email) ?></td>
            <td><?= esc_html($a->contact) ?></td>
            <td><?= esc_html($a->address) ?></td>
            <td><?= esc_html($a->price) ?></td>
            <td><?= esc_html($a->created_at) ?></td>
            <td>
                <a href="<?= site_url('/product-detail/?id=' . $a->product_id) ?>" target="_blank" class="action-btn action-view">
                    <i class="bi bi-eye"></i> View
                </a>
                <a href="?delete_abandoned_order=<?= $a->id ?>" class="action-btn action-delete" onclick="return confirm('Delete this abandoned order?')">
                    <i class="bi bi-trash"></i> Delete
                </a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>


<!-- Blogs Section -->
<div class="data-table section" id="blogs" style="display:none;">
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h5>All Blogs</h5>
        <div class="search-box">
            <input type="text" id="searchBlogs"
                   onkeyup="searchTable('searchBlogs','blogsTable')"
                   placeholder="Search blogs...">
        </div>
    </div>

   <table id="blogsTable">
    <tr>
        <th>ID</th>
        <th>Blog Title</th>
        <th>Date Posted</th>
        <th>Category</th>
        <th>Action</th>
    </tr>

    <?php foreach ($all_blogs as $post): ?>
    <tr>
        <td><?= esc_html($post->ID) ?></td>
        <td><?= esc_html($post->post_title) ?></td>
        <td><?= esc_html(get_the_date('Y-m-d', $post->ID)) ?></td>
        <td>
            <?php 
                $categories = get_the_category($post->ID);
                if (!empty($categories)) {
                    $cat_names = array_map(function($cat) { return $cat->name; }, $categories);
                    echo esc_html(implode(', ', $cat_names));
                } else {
                    echo 'Uncategorized';
                }
            ?>
        </td>
        <td>
            <a href="<?= get_permalink($post->ID) ?>" target="_blank" class="action-btn action-view">
                <i class="bi bi-eye"></i> View
            </a>

            <a href="<?= site_url('/edit-blog/?post_id=' . $post->ID) ?>" class="action-btn action-edit">
               <i class="bi bi-pencil"></i> Edit
            </a>

            <a href="?delete_blog=<?= $post->ID ?>" class="action-btn action-delete"
               onclick="return confirm('Delete this blog?')">
                <i class="bi bi-trash"></i> Delete
            </a>
        </td>
    </tr>
    <?php endforeach; ?>
</table>

</div>


</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    const blogStatus = urlParams.get('blog_status');

    if(blogStatus === 'published') {
        alert('Your article is published!');
        window.location.href = window.location.pathname; // redirect to current page without query
    }

    if(blogStatus === 'updated') {
        alert('Your article is updated!');
        window.location.href = window.location.pathname; // redirect to current page without query
    }
});
</script>

</body>
</html>