<?php
/**
 * Template Name: Super Admin Edit Job
 */
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');
global $wpdb;

if (session_status() === PHP_SESSION_NONE) session_start();

// ✅ Make sure user is logged in
// if (!is_user_logged_in()) {
//     wp_redirect(home_url());
//     exit;
// }

$jobs_table = 'farm_jobs';
$job_id = $_GET['id'] ?? 0;

if (!$job_id) {
    echo "<div style='color:red;text-align:center;margin-top:50px;'>Invalid request — job ID missing.</div>";
    exit;
}

// ✅ Fetch job data
$job = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$jobs_table} WHERE id = %d", $job_id));
if (!$job) {
    echo "<div style='color:red;text-align:center;margin-top:50px;'>Job not found.</div>";
    exit;
}

// Predefined options
$roles = ['Veterinary Doctor / Manager', 'Dairy Nutritionist / Consultant', 'Veterinary Assistant / AIT', 'Milkers', 'Dairy Accountant / Data Entry Operator', 'Others'];
$salary_packages = ['30,000 - 50,000', '50,000 - 100,000', '100,000 - 150,000', 'Above 150,000'];
$benefits_options = ['Meal & Residency', 'Bonus on Performance Base'];

$current_benefits = !empty($job->benefits) ? explode(', ', $job->benefits) : [];

// ✅ Update job on form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'role'            => sanitize_text_field($_POST['role']),
        'experience'      => sanitize_text_field($_POST['experience']),
        'key_requirements'=> sanitize_textarea_field($_POST['key_requirements']),
        'farm_name'       => sanitize_text_field($_POST['farm_name']),
        'total_animals'   => intval($_POST['total_animals']),
        'milking_cows'    => intval($_POST['milking_cows']),
        'address'         => sanitize_text_field($_POST['address']),
        'city'            => sanitize_text_field($_POST['city']),
        'farm_about'      => sanitize_textarea_field($_POST['farm_about']),
        'salary_package'  => sanitize_text_field($_POST['salary_package']),
        'benefits'        => !empty($_POST['benefits']) ? implode(', ', $_POST['benefits']) : '',

        // ⭐ ADD THESE TWO LINES
        'job_visibility'  => sanitize_text_field($_POST['job_visibility']),
        'status'          => sanitize_text_field($_POST['status']),
    ];

    $wpdb->update($jobs_table, $data, ['id' => $job_id]);

    echo "<script>alert('✅ Job updated successfully!'); window.location.href='" . site_url('/super-admin-dashboard') . "';</script>";
    exit;
}


get_header();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Edit Job — Super Admin</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
    body {
      background-color: #f4f6f9;
      font-family: "League Spartan", sans-serif;
    }
    .form-section {
      background: #fff;
      padding: 25px;
      border-radius: 12px;
      box-shadow: 0 0 12px rgba(0,0,0,0.05);
      margin-bottom: 30px;
    }
    .form-heading {
      font-weight: 700;
      font-size: 16px;
      margin-bottom: 20px;
      border-bottom: 2px solid #e3e6ea;
      padding-bottom: 5px;
      color: #0d6efd;
    }
    label {
      font-weight: 600;
      margin-bottom: 5px;
      color: #000;
    }
    .form-control {
      border-radius: 6px;
    }
    .radio-group, .checkbox-group {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      margin-top: 10px;
    }
    .radio-group label, .checkbox-group label {
      display: flex;
      align-items: center;
      gap: 6px;
      font-weight: 500;
    }
    .submit-btn {
      background: #0d6efd;
      color: white;
      border: none;
      padding: 12px 30px;
      border-radius: 8px;
      font-weight: 600;
      transition: 0.3s;
    }
    .submit-btn:hover {
      background: #084bb8;
    }
    .page-title {
      font-weight: 700;
      font-size: 22px;
      margin-bottom: 10px;
    }
    .page-subtitle {
      font-size: 14px;
      color: #666;
      margin-bottom: 30px;
    }
  </style>
</head>
<body>

<div class="container my-5">
  <div class="text-center mb-4">
    <div class="page-title">Edit Job</div>
    <div class="page-subtitle">(Modify the job details below)</div>
  </div>

  <form method="POST">
    
    <!-- Section: Job Information -->
    <div class="form-section">
      <div class="form-heading">Job Information</div>

        <div class="mb-3">
    <label class="form-label d-block">Select Role</label>
    <select class="form-select" name="role" required>

        <!-- Group 1 -->
        <option disabled style="color:red">Veterinary & Farm Management</option>

        <option value="Veterinary Doctor (DVM)"
            <?= ($job->role == 'Veterinary Doctor (DVM)') ? 'selected' : ''; ?>>
            Veterinary Doctor (DVM)
        </option>

        <option value="Veterinary Doctor & Farm Manager"
            <?= ($job->role == 'Veterinary Doctor & Farm Manager') ? 'selected' : ''; ?>>
            Veterinary Doctor & Farm Manager
        </option>

        <option value="Veterinary Assistant (VA)"
            <?= ($job->role == 'Veterinary Assistant (VA)') ? 'selected' : ''; ?>>
            Veterinary Assistant (VA)
        </option>

        <option value="Artificial Insemination Technician (AIT)"
            <?= ($job->role == 'Artificial Insemination Technician (AIT)') ? 'selected' : ''; ?>>
            Artificial Insemination Technician (AIT)
        </option>

        <option value="Dairy Farm Consultant"
            <?= ($job->role == 'Dairy Farm Consultant') ? 'selected' : ''; ?>>
            Dairy Farm Consultant
        </option>

        <option value="Dairy Nutritionist"
            <?= ($job->role == 'Dairy Nutritionist') ? 'selected' : ''; ?>>
            Dairy Nutritionist
        </option>

        <option value="Dairy Farm Supervisor"
            <?= ($job->role == 'Dairy Farm Supervisor') ? 'selected' : ''; ?>>
            Dairy Farm Supervisor
        </option>


        <!-- Group 2 -->
        <option disabled style="color:red">Farm Operations</option>

        <option value="Milkers"
            <?= ($job->role == 'Milkers') ? 'selected' : ''; ?>>
            Milkers
        </option>

        <option value="Tractor Drivers"
            <?= ($job->role == 'Tractor Drivers') ? 'selected' : ''; ?>>
            Tractor Drivers
        </option>

        <option value="Data Entry Operator"
            <?= ($job->role == 'Data Entry Operator') ? 'selected' : ''; ?>>
            Data Entry Operator
        </option>

        <option value="Dairy Accountant"
            <?= ($job->role == 'Dairy Accountant') ? 'selected' : ''; ?>>
            Dairy Accountant
        </option>

    </select>
</div>

      

      <div class="mb-3">
        <label class="form-label">Experience Required</label>
        <input type="text" name="experience" class="form-control" value="<?=esc_attr($job->experience)?>">
      </div>

      <div class="mb-3">
        <label class="form-label">Key Requirements</label>
        <textarea name="key_requirements" class="form-control" rows="3"><?=esc_textarea($job->key_requirements)?></textarea>
      </div>
    </div>

    <!-- Section: Farm Details -->
    <div class="form-section">
      <div class="form-heading">Farm Details</div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label">Farm Name</label>
          <input type="text" name="farm_name" class="form-control" value="<?=esc_attr($job->farm_name)?>">
        </div>
        <div class="col-md-6 mb-3">
          <label class="form-label">Total Animals</label>
          <input type="number" name="total_animals" class="form-control" value="<?=esc_attr($job->total_animals)?>">
        </div>
        <div class="col-md-6 mb-3">
          <label class="form-label">Milking Cows</label>
          <input type="number" name="milking_cows" class="form-control" value="<?=esc_attr($job->milking_cows)?>">
        </div>
        <div class="col-md-6 mb-3">
          <label class="form-label">City</label>
          <input type="text" name="city" class="form-control" value="<?=esc_attr($job->city)?>">
        </div>
        <div class="col-12 mb-3">
          <label class="form-label">Address</label>
          <input type="text" name="address" class="form-control" value="<?=esc_attr($job->address)?>">
        </div>
        <div class="col-12 mb-3">
          <label class="form-label">About Farm</label>
          <textarea name="farm_about" class="form-control" rows="4"><?=esc_textarea($job->farm_about)?></textarea>
        </div>
      </div>
    </div>

    <!-- Section: Salary & Benefits -->
    <div class="form-section">
      <div class="form-heading">Salary & Benefits</div>

      <label class="form-label">Salary Package</label>
      <div class="radio-group mb-3">
        <?php foreach ($salary_packages as $pkg): ?>
          <label>
            <input type="radio" name="salary_package" value="<?php echo esc_attr($pkg); ?>" 
              <?php checked($pkg, $job->salary_package); ?>> <?php echo esc_html($pkg); ?>
          </label>
        <?php endforeach; ?>
      </div>

      <label class="form-label">Other Benefits</label>
      <div class="checkbox-group mb-3">
        <?php foreach ($benefits_options as $benefit): ?>
          <label>
            <input type="checkbox" name="benefits[]" value="<?php echo esc_attr($benefit); ?>" 
              <?php if (in_array($benefit, $current_benefits)) echo 'checked'; ?>> 
              <?php echo esc_html($benefit); ?>
          </label>
        <?php endforeach; ?>
      </div>
      
      
      <!-- Section: Job Visibilty -->
        <!-- Section: Job Visibility -->
            <div class="form-heading">Job Visibility</div>
        
            <div class="mb-3">
                <label class="form-label d-block">Post a Job</label>
        
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="job_visibility" value="public"
                        <?php checked($job->job_visibility, 'public'); ?> required>
                    <label class="form-check-label">Publicly</label>
                    <span style="margin-left:6px; font-size:14px;font-weight:400;">
                        (If you want to display this job publicly)
                    </span>
                </div>
        
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="job_visibility" value="confidential"
                        <?php checked($job->job_visibility, 'confidential'); ?>>
                    <label class="form-check-label">Confidential</label>
                    <span style="margin-left:6px; font-size:14px;font-weight:400;">
                        (If you want to keep this job private)
                    </span>
                </div>
            </div>


      
      <!-- Section: Job Status -->
            <div class="form-heading">Job Status</div>
        
            <div class="radio-group mb-3">
                <label>
                    <input type="radio" name="status" value="approved" 
                        <?php checked($job->status, 'approved'); ?>> Approved
                </label>
        
                <label>
                    <input type="radio" name="status" value="pending" 
                        <?php checked($job->status, 'pending'); ?>> Pending
                </label>
        
                <label>
                    <input type="radio" name="status" value="rejected" 
                        <?php checked($job->status, 'rejected'); ?>> Rejected
                </label>
            </div>
   


    </div>

    <div class="text-center">
      <button type="submit" class="submit-btn">Save Changes</button>
    </div>
  </form>
</div>

</body>
<?php get_footer('custom'); ?>
</html>
