<?php
/**
 * Template Name: Super Admin Edit User
 */
require_once($_SERVER['DOCUMENT_ROOT'].'/wp-load.php');
global $wpdb;

if(session_status()===PHP_SESSION_NONE) session_start();
if(!is_user_logged_in()){ wp_redirect(home_url()); exit; }

$id = intval($_GET['id'] ?? 0);

// Fetch user info
$user = $wpdb->get_row($wpdb->prepare("SELECT * FROM user_info WHERE id=%d", $id));
$profile = $wpdb->get_row($wpdb->prepare("SELECT * FROM user_profiles WHERE user_id=%d", $id));
$education = $wpdb->get_results($wpdb->prepare("SELECT * FROM user_education WHERE user_id=%d", $id));
$experience = $wpdb->get_results($wpdb->prepare("SELECT * FROM user_experience WHERE user_id=%d", $id));

if($_POST){
    // Update user_info
    $wpdb->update('user_info', [
        'username' => $_POST['username'],
        'email' => $_POST['email'],
        'contact' => $_POST['contact'],
    ], ['id' => $id]);

    // Update user_profiles
    $wpdb->update('user_profiles', [
        'birthdate' => $_POST['birthdate'],
        'city' => $_POST['city'],
        'bio' => $_POST['bio'],
        'skills' => implode(',', $_POST['skills']),
        // image upload handling here if needed
    ], ['user_id' => $id]);

    echo "<script>alert('User updated successfully');window.location='".site_url('/super-admin')."';</script>";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Edit User</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{font-family: Arial, sans-serif; background:#f8f9fa;}
.card{border-radius:10px; margin-bottom:20px; box-shadow:0 2px 8px rgba(0,0,0,0.05);}
.card-header{background:#0073aa;color:#fff;font-weight:bold;font-size:16px;}
.form-label{font-weight:600;}
.img-preview{width:100px;height:100px;border-radius:50%;object-fit:cover;margin-bottom:10px;border:1px solid #ccc;}
.btn-add{background:#198754;color:#fff;}
.btn-remove{background:#dc3545;color:#fff;}
</style>
</head>
<body>
<div class="container my-4">
<a href="<?=site_url('/super-admin')?>" class="btn btn-primary mb-3">← Back to Dashboard</a>
<form action="<?php echo esc_url(get_template_directory_uri() . '/page-templates/super-admin-user-update-profile.php'); ?>" method="post" enctype="multipart/form-data">

<!-- User Info -->
<div class="card">
  <div class="card-header">User Information</div>
  <div class="card-body">
    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Username</label>
        <input type="text" name="username" class="form-control" value="<?=esc_attr($user->username)?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" value="<?=esc_attr($user->email)?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Contact</label>
        <input type="text" name="contact" class="form-control" value="<?=esc_attr($user->contact)?>" required>
      </div>
    </div>
  </div>
</div>

<!-- Profile Info -->
<div class="card">
  <div class="card-header">Profile Details</div>
  <div class="card-body">
    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Birth Date</label>
        <input type="date" name="birthdate" class="form-control" value="<?=esc_attr($profile->birthdate)?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">City</label>
        <input type="text" name="city" class="form-control" value="<?=esc_attr($profile->city)?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Profile Image</label><br>
        <?php if(!empty($profile->image)){ ?>
            <img src="https://rumicare.bibigadgets.com/wp-content/themes/onum/page-templates/uploads/<?=($profile->image)?>" class="img-preview" id="profilePreview">
        <?php } else { ?>
            <img src="https://via.placeholder.com/100" class="img-preview" id="profilePreview">
        <?php } ?>
        <input type="file" name="image" class="form-control mt-1" accept="image/*" onchange="previewImage(event)">
      </div>
      <div class="col-md-12">
        <label class="form-label">Bio</label>
        <textarea name="bio" class="form-control" rows="3" required><?=esc_textarea($profile->bio)?></textarea>
      </div>
      <div class="col-md-12">
        <label class="form-label">Skills</label>
        <select name="skills[]" class="form-control" multiple>
          <?php 
          $skills_arr = explode(',', $profile->skills);
          $all_skills = ['Feed Formulation','Hoof Trimming','Artificial Insemination','Pregnancy Diagnosis','Minor Surgery','Major Surgery','Working on Excel Sheet','Record Keeping on Software','Calf Care','Milking Parlor Handling'];
          foreach($all_skills as $sk){ ?>
            <option value="<?=$sk?>" <?=in_array($sk,$skills_arr)?'selected':''?>><?=$sk?></option>
          <?php } ?>
        </select>
      </div>
    </div>
  </div>
</div>

<!-- Education -->
<div class="card">
  <div class="card-header d-flex justify-content-between align-items-center">
    <span>Education</span>
    <button type="button" class="btn btn-add btn-sm" onclick="addEducation()">+ Add Education</button>
  </div>
  <div class="card-body" id="education-container">
    <?php if($education){
      foreach($education as $edu){ ?>
        <div class="border p-2 mb-2 rounded">
          <div class="row g-2 align-items-end">
            <div class="col-md-4">
              <label class="form-label">Course</label>
              <input type="text" name="course[]" class="form-control" value="<?=esc_attr($edu->course)?>" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Institute</label>
              <input type="text" name="institute[]" class="form-control" value="<?=esc_attr($edu->institute)?>" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">Completion Date</label>
              <input type="date" name="completion_date[]" class="form-control" value="<?=esc_attr($edu->completion_date)?>" required>
            </div>
            <div class="col-md-1 text-end"><button type="button" class="btn btn-remove" onclick="this.closest('.border').remove()">×</button></div>
          </div>
        </div>
    <?php }} ?>
  </div>
</div>

<!-- Work Experience -->
<div class="card">
  <div class="card-header d-flex justify-content-between align-items-center">
    <span>Work Experience</span>
    <button type="button" class="btn btn-add btn-sm" onclick="addExperience()">+ Add Experience</button>
  </div>
  <div class="card-body" id="experience-container">
    <?php if($experience){
      foreach($experience as $exp){ ?>
        <div class="border p-2 mb-2 rounded">
          <div class="row g-2 align-items-end">
            <div class="col-md-4">
              <label class="form-label">Company Name</label>
              <input type="text" name="company_name[]" class="form-control" value="<?=esc_attr($exp->company_name)?>" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Job Title</label>
              <input type="text" name="job_designation[]" class="form-control" value="<?=esc_attr($exp->job_designation)?>" required>
            </div>
            <div class="col-md-2">
              <label class="form-label">Start Date</label>
              <input type="date" name="start_date[]" class="form-control" value="<?=esc_attr($exp->start_date)?>" required>
            </div>
            <div class="col-md-2">
              <label class="form-label">End Date</label>
              <input type="date" name="end_date[]" class="form-control" value="<?=esc_attr($exp->end_date)?>">
            </div>
            <div class="col-md-12 mt-2">
              <label class="form-label">Responsibilities</label>
              <textarea name="work_responsibilities[]" class="form-control" rows="2" required><?=esc_textarea($exp->work_responsibilities)?></textarea>
            </div>
            <div class="col-md-12 text-end mt-1"><button type="button" class="btn btn-remove" onclick="this.closest('.border').remove()">× Remove</button></div>
          </div>
        </div>
    <?php }} ?>
  </div>
</div>
<input type="hidden" name="user_id" value="<?php echo esc_attr($id); ?>">


<button type="submit" class="btn btn-primary mt-3">Update User</button>
</form>
</div>

<script>
// Image preview
function previewImage(event){
  const reader = new FileReader();
  reader.onload = function(){
    document.getElementById('profilePreview').src = reader.result;
  }
  reader.readAsDataURL(event.target.files[0]);
}

// Education
function addEducation(){
  const container = document.getElementById('education-container');
  const div = document.createElement('div');
  div.classList.add('border','p-2','mb-2','rounded');
  div.innerHTML = `<div class="row g-2 align-items-end">
    <div class="col-md-4"><label class="form-label">Course</label><input type="text" name="course[]" class="form-control" required></div>
    <div class="col-md-4"><label class="form-label">Institute</label><input type="text" name="institute[]" class="form-control" required></div>
    <div class="col-md-3"><label class="form-label">Completion Date</label><input type="date" name="completion_date[]" class="form-control" required></div>
    <div class="col-md-1 text-end"><button type="button" class="btn btn-remove" onclick="this.closest('.border').remove()">×</button></div>
  </div>`;
  container.appendChild(div);
}

// Work Experience
function addExperience(){
  const container = document.getElementById('experience-container');
  const div = document.createElement('div');
  div.classList.add('border','p-2','mb-2','rounded');
  div.innerHTML = `<div class="row g-2 align-items-end">
    <div class="col-md-4"><label class="form-label">Company Name</label><input type="text" name="company_name[]" class="form-control" required></div>
    <div class="col-md-4"><label class="form-label">Job Title</label><input type="text" name="job_designation[]" class="form-control" required></div>
    <div class="col-md-2"><label class="form-label">Start Date</label><input type="date" name="start_date[]" class="form-control" required></div>
    <div class="col-md-2"><label class="form-label">End Date</label><input type="date" name="end_date[]" class="form-control"></div>
    <div class="col-md-12 mt-2"><label class="form-label">Responsibilities</label><textarea name="work_responsibilities[]" class="form-control" rows="2" required></textarea></div>
    <div class="col-md-12 text-end mt-1"><button type="button" class="btn btn-remove" onclick="this.closest('.border').remove()">× Remove</button></div>
  </div>`;
  container.appendChild(div);
}
</script>
</body>
</html>
