<?php
// Load WordPress environment
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');

// Access the global $wpdb object
global $wpdb;

// Start session (important!)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Your custom table name
$table_name = 'super_admin';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Sanitize form inputs
    $username = sanitize_text_field($_POST['username'] ?? '');
    $email    = sanitize_email($_POST['email'] ?? '');
    $password = sanitize_text_field($_POST['password'] ?? '');
    $contact  = sanitize_text_field($_POST['contact'] ?? '');

    // Check if email already exists
    $email_exists = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM $table_name WHERE email = %s",
        $email
    ));

    if ($email_exists) {
        // Email already exists
        $msg = "Email is already present!";
        echo "<script>
                alert('$msg');
                window.location.href = 'https://rumicare.bibigadgets.com/super-admin-singup/';
              </script>";
        exit;
    }

    // Hash the password
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    // Generate a reset token
    $reset_token = wp_generate_password(32, false);

    // Current date/time
    $created_at = current_time('mysql');

    // Insert data into custom table
    $inserted = $wpdb->insert(
        $table_name,
        [
            'username'    => $username,
            'email'       => $email,
            'password'    => $hashed_password,
            'reset_token' => $reset_token,
            'contact'     => $contact,
            'created_at'  => $created_at,
        ],
        [
            '%s', '%s', '%s', '%s', '%s', '%s'
        ]
    );

    if ($inserted) {

        // ✅ Get the newly inserted user ID
        $user_id = $wpdb->insert_id;

        // ✅ Set session data to auto-login
        $_SESSION['user_id'] = $user_id;
        $_SESSION['username'] = $username;
        $_SESSION['email'] = $email;

        // ✅ Redirect to registration page
        echo "<script>
                alert('Signup Successful! You are now logged in.');
                window.location.href = 'https://rumicare.bibigadgets.com/super-admin-dashboard/';
              </script>";
        exit;

    } else {
        echo "<h3 style='color:red;'>Error: Unable to insert data into database.</h3>";
        echo "<pre>";
        print_r($wpdb->last_error);
        echo "</pre>";
    }

} else {
    echo "No form data received.";
}
?>
