<?php
/**
 * Template Name: Supper Admin Signup
 * Description: Professional user signup page for job seekers.
 */

get_header();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>User Signup</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <!-- Google Font -->
  <link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
    body {
      background-color: #f8f9fa;
      font-family: "League Spartan", sans-serif;
      color: #000;
      font-size: 13px;
      font-weight: 500;
    }

    .main-sec {
      width: 85%;
      margin: 20px auto 0;
    }

    .form-section {
      background: #fff;
      padding: 25px;
      border-radius: 12px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      margin: 25px auto;
    }

    .form-heading {
      font-weight: 700;
      font-size: 15px;
      margin-bottom: 20px;
      border-bottom: 2px solid #dee2e6;
      padding-bottom: 5px;
      color: red;
    }

    .head-text {
      font-weight: 700;
      font-size: 15px;
      color: #000;
    }

    .head-para {
      font-weight: 400;
      font-size: 13px;
      color: #000;
    }

    .form-control {
      border-radius: 3px !important;
    }

    /*.text-endd {*/
    /*  width: 90%;*/
    /*  margin: auto;*/
    /*}*/

    .text-endd button {
      width: 100%;
      font-size: 14px;
      padding: 6px 0;
    }
    
    
    @media screen and (max-width: 600px) {
     .container { max-width: 90%;}
    
    }
  </style>
</head>
<body>

  <div class="main-sec d-flex justify-content-between align-items-center">
    <div>
      <div class="head-text">Singup First to Complete the Profile</div>
    </div>
    <div>
      <img src="<?php echo get_template_directory_uri(); ?>/page-templates/3wsz.svg" alt="Icon">
    </div>
  </div>

  <div class="container">
    <form action="<?php echo esc_url(get_template_directory_uri() . '/page-templates/super-admin-signup-submit.php'); ?>" method="POST" enctype="multipart/form-data">
      
      <div class="form-section">
        <div class="form-heading">Create Account</div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label class="form-label">Full Name</label>
            <input type="text" name="username" class="form-control" placeholder="Enter your full name" required>
          </div>

          <div class="col-md-6 mb-3">
            <label class="form-label">Email Address (Optional)</label>
            <input type="email" name="email" class="form-control" placeholder="example@example.com">
          </div>


        <div class="col-md-6 mb-3">
            <label class="form-label">Whatsapp No</label>
            <input type="tel" name="contact" class="form-control" placeholder="e.g. +1234567890" required>
          </div>

          <div class="col-md-6 mb-3">
            <label class="form-label">Password</label>
            <div class="input-group">
              <input type="password" name="password" id="passwordField" class="form-control" placeholder="Enter your password" required>
              <button type="button" class="btn btn-outline-secondary" id="togglePassword">
                <i class="fa-solid fa-eye" id="eyeIcon"></i>
              </button>
            </div>
          </div>

         
        </div>
      </div>

      <div class="text-endd">
        <button type="submit" class="btn btn-primary">Submit</button>
      </div>

    </form>
  </div>

  <!-- Bootstrap 5 JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const passwordField = document.getElementById('passwordField');
      const togglePassword = document.getElementById('togglePassword');
      const eyeIcon = document.getElementById('eyeIcon');

      togglePassword.addEventListener('click', function() {
        const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordField.setAttribute('type', type);
        eyeIcon.classList.toggle('fa-eye');
        eyeIcon.classList.toggle('fa-eye-slash');
      });
    });
  </script>

  <?php get_footer('custom'); ?>
</body>
</html>
