<?php
/**
 * Handles profile update requests (called from Super Admin Edit User)
 */
require_once('../../../../wp-load.php');
global $wpdb;

// ================================
// 🚨 1️⃣ Verify Request Type
// ================================
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    wp_die('Invalid request.');
}

// ================================
// 🚨 2️⃣ Get and Validate user_id
// ================================
$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
if ($user_id <= 0) {
    wp_die('Invalid request — user ID missing.');
}

// ================================
// 📂 3️⃣ Setup Upload Directory
// ================================
$upload_dir = get_template_directory() . '/page-templates/uploads/';
$upload_url = get_template_directory_uri() . '/page-templates/uploads/';

if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// ================================
// 🖼️ 4️⃣ Handle Image Upload
// ================================
$old_image = $wpdb->get_var($wpdb->prepare(
    "SELECT image FROM user_profiles WHERE user_id = %d",
    $user_id
));
$image_url = $old_image ? $old_image : '';

if (!empty($_FILES['image']['name'])) {
    // Remove old file if exists
    if (!empty($old_image)) {
        $old_path = $upload_dir . basename($old_image);
        if (file_exists($old_path)) unlink($old_path);
    }

    $image_name = time() . "_" . basename($_FILES["image"]["name"]);
    $target_file = $upload_dir . $image_name;

    if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
        $image_url = "uploads/" . $image_name;
    } else {
        wp_die("Error uploading image.");
    }
}

// ================================
// ✍️ 5️⃣ Sanitize Inputs
// ================================
$username   = sanitize_text_field($_POST['username']);
$email      = sanitize_email($_POST['email']);
$contact    = sanitize_text_field($_POST['contact']);
$birthdate  = sanitize_text_field($_POST['birthdate']);
$city       = sanitize_text_field($_POST['city']);
$bio        = sanitize_textarea_field($_POST['bio']);
$skills     = isset($_POST['skills']) ? implode(',', array_map('sanitize_text_field', $_POST['skills'])) : "";

// ================================
// 🧩 6️⃣ Update user_info
// ================================
$wpdb->update(
    'user_info',
    [
        'username' => $username,
        'email'    => $email,
        'contact'  => $contact,
    ],
    ['id' => $user_id]
);

// ================================
// 🧩 7️⃣ Update user_profiles
// ================================
$wpdb->update(
    'user_profiles',
    [
        'birthdate' => $birthdate,
        'city'      => $city,
        'bio'       => $bio,
        'skills'    => $skills,
        'image'     => $image_url,
    ],
    ['user_id' => $user_id]
);

// ================================
// 🎓 8️⃣ Update Education
// ================================
$wpdb->delete('user_education', ['user_id' => $user_id]);

if (!empty($_POST['course'])) {
    foreach ($_POST['course'] as $i => $course) {
        $institute = sanitize_text_field($_POST['institute'][$i] ?? '');
        $completion_date = sanitize_text_field($_POST['completion_date'][$i] ?? '');
        if (!empty($course) && !empty($institute)) {
            $wpdb->insert('user_education', [
                'user_id' => $user_id,
                'course' => $course,
                'institute' => $institute,
                'completion_date' => $completion_date
            ]);
        }
    }
}

// ================================
// 💼 9️⃣ Update Experience
// ================================
$wpdb->delete('user_experience', ['user_id' => $user_id]);

if (!empty($_POST['company_name'])) {
    foreach ($_POST['company_name'] as $i => $company_name) {
        $job_designation = sanitize_text_field($_POST['job_designation'][$i] ?? '');
        $start_date = sanitize_text_field($_POST['start_date'][$i] ?? '');
        $end_date = sanitize_text_field($_POST['end_date'][$i] ?? '');
        $responsibilities = sanitize_textarea_field($_POST['work_responsibilities'][$i] ?? '');
        if (!empty($company_name) && !empty($job_designation)) {
            $wpdb->insert('user_experience', [
                'user_id' => $user_id,
                'company_name' => $company_name,
                'job_designation' => $job_designation,
                'start_date' => $start_date,
                'end_date' => $end_date,
                'work_responsibilities' => $responsibilities
            ]);
        }
    }
}

// ================================
// ✅ 10️⃣ Redirect with Success Message
// ================================
echo "<script>
    alert('Profile updated successfully!');
    window.location.href='" . esc_url(site_url('/super-admin-view-user/?id=' . $user_id)) . "';
</script>";
exit;
?>
