<?php
/**
 * Template Name: Super Admin View Farmer
 */
require_once($_SERVER['DOCUMENT_ROOT'].'/wp-load.php');
global $wpdb;

$farmer_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$farmer_info = $wpdb->get_row("SELECT * FROM farmers_info WHERE id = $farmer_id");
$farm_jobs = $wpdb->get_results("SELECT * FROM farm_jobs WHERE farmer_id = $farmer_id ORDER BY id DESC");
?>
<!DOCTYPE html>
<html>
<head>
<title>Super Admin | View Farmer</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body {
    background: #f1f3f8;
    font-family: "Poppins", Arial, sans-serif;
    margin: 0;
    padding: 0;
    color: #333;
}

.container {
    max-width: 1200px;
    margin: 40px auto;
    padding: 0 20px;
}

.card {
    background: #fff;
    border-radius: 14px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    padding: 25px 30px;
    margin-bottom: 25px;
    transition: 0.3s;
}

.card:hover {
    box-shadow: 0 6px 20px rgba(0,0,0,0.12);
}

.header {
    display: flex;
    align-items: center;
    border-bottom: 2px solid #eaeaea;
    padding-bottom: 20px;
    margin-bottom: 25px;
}

.header img {
    width: 100px;
    height: 100px;
    border-radius: 50%;
    object-fit: cover;
    margin-right: 25px;
    border: 3px solid #0073aa;
}

.header h2 {
    margin: 0;
    color: #0073aa;
    font-size: 24px;
}

.header p {
    margin: 5px 0;
    color: #555;
}

.section-title {
    font-size: 18px;
    color: #0073aa;
    font-weight: 600;
    margin-bottom: 15px;
    border-left: 5px solid #0073aa;
    padding-left: 10px;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 15px;
}

.info-item {
    background: #f8fafc;
    padding: 12px 15px;
    border-radius: 8px;
    border: 1px solid #e0e0e0;
}

.info-item strong {
    display: block;
    color: #444;
    font-weight: 600;
    margin-bottom: 5px;
}

.table-wrapper {
    overflow-x: auto;
}

table {
    width: 100%;
    border-collapse: collapse;
    border-radius: 10px;
    overflow: hidden;
}

table th, table td {
    padding: 12px 15px;
    border-bottom: 1px solid #e5e5e5;
    text-align: left;
    font-size: 15px;
}

table th {
    background: #0073aa;
    color: #fff;
    font-weight: 600;
}

table tr:hover {
    background-color: #f9fafc;
}

.no-data {
    color: #888;
    font-style: italic;
    padding: 10px;
}

.back-btn {
    display: inline-block;
    background: #0073aa;
    color: #fff;
    padding: 10px 18px;
    border-radius: 6px;
    text-decoration: none;
    margin-bottom: 20px;
    transition: 0.3s;
}

.back-btn:hover {
    background: #005f8d;
}

.action-btns a {
    display: inline-block;
    margin-right: 6px;
    padding: 6px 10px;
    border-radius: 6px;
    font-size: 13px;
    text-decoration: none;
    color: #fff;
    transition: 0.3s;
}
.action-btns .view { background: #0073aa; }
.action-btns .view:hover { background: #005f8d; }
.action-btns .edit { background: #28a745; }
.action-btns .edit:hover { background: #218838; }
.action-btns .delete { background: #dc3545; }
.action-btns .delete:hover { background: #c82333; }
</style>
</head>
<body>

<div class="container">
    <a href="<?= site_url('/super-admin') ?>" class="back-btn">← Back to Dashboard</a>

    <?php if ($farmer_info): ?>
    <div class="card header">
        <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/10/3wresdxzc.png" alt="Farmer Image">
        <div>
            <h2><?= esc_html($farmer_info->full_name); ?></h2>
            <p><strong>Email:</strong> <?= esc_html($farmer_info->email); ?></p>
            <p><strong>Contact:</strong> <?= esc_html($farmer_info->contact); ?></p>
            <p><strong>Created At:</strong> <?= esc_html($farmer_info->created_at); ?></p>
        </div>
    </div>

    <!-- Jobs Posted -->
    <div class="card">
        <h3 class="section-title">Jobs Posted</h3>
        <?php if ($farm_jobs): ?>
        <div class="table-wrapper">
            <table>
                <tr>
                    <th>Job ID</th>
                    <th>Farm Name</th>
                    <th>Role</th>
                    <th>City</th>
                    <th>Experience</th>
                    <th>Salary</th>
                    <th>Posted On</th>
                    <th>Action</th>
                </tr>
                <?php foreach ($farm_jobs as $job): ?>
                <tr>
                    <td><?= esc_html($job->id); ?></td>
                    <td><?= esc_html($job->farm_name); ?></td>
                    <td><?= esc_html($job->role); ?></td>
                    <td><?= esc_html($job->city); ?></td>
                    <td><?= esc_html($job->experience); ?></td>
                    <td><?= esc_html($job->salary_package); ?></td>
                    <td><?= esc_html(date('Y-m-d', strtotime($job->created_at))); ?></td>
                    <td class="action-btns">
                        <a href="<?= site_url('/super-admin-view-job/?id='.$job->id) ?>" class="view">View</a>
                        <a href="<?= site_url('/super-admin-edit-job/?id='.$job->id) ?>" class="edit">Edit</a>
                        <a href="#" class="delete" onclick="return confirmDelete(<?= $job->id; ?>)">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </table>
        </div>
        <?php else: ?>
            <p class="no-data">No jobs found for this farmer.</p>
        <?php endif; ?>
    </div>

    <?php else: ?>
        <p class="no-data">Farmer not found.</p>
    <?php endif; ?>
</div>

<script>
function confirmDelete(jobId) {
    if (confirm("Are you sure you want to delete this job?")) {
        window.location.href = "<?= site_url('/super-admin-delete-job/?id=') ?>" + jobId;
    }
    return false;
}
</script>

</body>
</html>
