<?php
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');
global $wpdb;

$job_id = intval($_GET['id'] ?? 0);
$job = $wpdb->get_row("SELECT * FROM farm_jobs WHERE id = $job_id");
$farmer = $job ? $wpdb->get_row("SELECT * FROM farmers_info WHERE id = {$job->farmer_id}") : null;
$applicants = $wpdb->get_results("
    SELECT u.id AS user_id, u.username, u.email, u.contact, j.applied_on
    FROM job_applications j
    INNER JOIN user_info u ON j.user_id = u.id
    WHERE j.job_id = $job_id
    ORDER BY j.applied_on DESC
");
?>
<!DOCTYPE html>
<html>
<head>
<title>Super Admin | View Job</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
body { background:#f1f3f8; font-family:'Poppins',Arial,sans-serif; margin:0; padding:0; color:#333; }
.container { max-width:1100px; margin:40px auto; padding:0 20px; }
.back-btn { display:inline-block; background:#0073aa; color:#fff; padding:10px 18px; border-radius:6px; text-decoration:none; margin-bottom:20px; transition:.3s; }
.back-btn:hover { background:#005f8d; }

/* Card Style */
.card { background:#fff; border-radius:12px; box-shadow:0 4px 20px rgba(0,0,0,0.08); padding:25px 30px; margin-bottom:30px; }
.card h2, .card h3 { margin-top:0; color:#0073aa; }

/* Info Grid */
.info-grid { display:grid; grid-template-columns:1fr 1fr; gap:15px; margin-top:15px; }
.info-item { padding:12px 15px; background:#f8fafc; border-radius:8px; border:1px solid #e0e0e0; }
.info-item strong { display:block; color:#444; margin-bottom:5px; font-weight:600; }

/* Table Style */
.table-wrapper { overflow-x:auto; margin-top:15px; }
table { width:100%; border-collapse:collapse; border-radius:10px; overflow:hidden; }
table th, table td { padding:12px 15px; border-bottom:1px solid #e5e5e5; font-size:15px; text-align:left; }
table th { background:#0073aa; color:#fff; font-weight:600; }
table tr:nth-child(even) { background:#f8f9fb; }
table tr:hover { background:#e9f0f7; }

/* Action Buttons */
.action-btn { display:inline-block; padding:6px 12px; border-radius:5px; text-decoration:none; color:#fff; font-size:13px; margin-right:6px; transition:.3s; }
.action-btn.view { background:#28a745; } .action-btn.view:hover { background:#218838; }
.action-btn.delete { background:#dc3545; } .action-btn.delete:hover { background:#b52a35; }

/* Responsive */
@media(max-width:768px){ .info-grid { grid-template-columns:1fr; } }
.no-data { color:#888; font-style:italic; padding:10px; }
</style>
</head>
<body>

<div class="container">
<a href="<?= site_url('/super-admin') ?>" class="back-btn">← Back to Dashboard</a>



<?php if($farmer): ?>
<div class="card">
<h2>Posted By</h2>
<div class="info-grid">
    <div class="info-item"><strong>Name</strong><?= esc_html($farmer->full_name); ?></div>
    <div class="info-item"><strong>Email</strong><?= esc_html($farmer->email); ?></div>
    <div class="info-item"><strong>WhatsApp / Contact</strong><?= esc_html($farmer->contact); ?></div>
    <div class="info-item"><strong>Created At</strong><?= esc_html($farmer->created_at); ?></div>
</div>
</div>

<?php if($job): ?>

<!-- Job Info Card -->
<div class="card">
<h2>Job Information</h2>
<div class="info-grid">
    <div class="info-item"><strong>Role</strong><?= esc_html($job->role); ?></div>
    <div class="info-item"><strong>Experience Required</strong><?= esc_html($job->experience); ?></div>
    <div class="info-item"><strong>Salary Package</strong><?= esc_html($job->salary_package); ?></div>
    <div class="info-item"><strong>Key Requirements</strong><?= esc_html($job->key_requirements); ?></div>
</div>
</div>




<!-- Farm Info Card -->
<div class="card">
<h2>Farm Details</h2>
<div class="info-grid">
    <div class="info-item"><strong>Farm Name</strong><?= esc_html($job->farm_name); ?></div>
    <div class="info-item"><strong>Total Animals</strong><?= esc_html($job->total_animals); ?></div>
    <div class="info-item"><strong>Milking Cows</strong><?= esc_html($job->milking_cows); ?></div>
    <div class="info-item"><strong>City</strong><?= esc_html($job->city); ?></div>
    <div class="info-item"><strong>Address</strong><?= esc_html($job->address); ?></div>
    <div class="info-item"><strong>About Farm</strong><?= esc_html($job->farm_about); ?></div>
    <div class="info-item"><strong>Farm Benefits</strong><?= esc_html($job->benefits); ?></div>
    <div class="info-item"><strong>Posted On</strong><?= esc_html($job->created_at); ?></div>
</div>
</div>

<!-- Posted By Card -->

<?php endif; ?>

<!-- Applicants Card -->
<div class="card">
<h3>Applicants</h3>
<?php if($applicants): ?>
<div class="table-wrapper">
<table>
<tr>
<th>Username</th><th>Email</th><th>Contact</th><th>Applied On</th><th>Actions</th>
</tr>
<?php foreach($applicants as $applicant): ?>
<tr>
<td><?= esc_html($applicant->username); ?></td>
<td><?= esc_html($applicant->email); ?></td>
<td><?= esc_html($applicant->contact); ?></td>
<td><?= esc_html($applicant->applied_on); ?></td>
<td>
<a href="<?= site_url('/super-admin-view-user?id='.$applicant->user_id); ?>" class="action-btn view">View</a>
<a href="#" class="action-btn delete" onclick="return confirm('Delete this application?');">Delete</a>
</td>
</tr>
<?php endforeach; ?>
</table>
</div>
<?php else: ?><p class="no-data">No applicants yet.</p><?php endif; ?>
</div>

<?php else: ?>
<p class="no-data">Job not found.</p>
<?php endif; ?>

</div>

</body>
</html>
