<?php
/**
 * Template Name: Training Page Template
 * Description: A Page Template showing farmers & employees.
 */

get_header();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Professional User Registration Form</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
body{background-color:#fffffa;}
.row{width:90%;margin:auto;}
.col-sm-4{width:50%;}
div,h1,h2,h3,h4,h5,h6,p,span{font-family:"League Spartan", Sans-serif;}
h4{font-size:16px;color:black;font-weight:600;}
p{font-size:13px;color:black;line-height:15px;}
.img-col{background-color:#CFF1FF;}
.img-col-main{width:90%;margin-top:20px; display: flex;
    justify-content: space-between;
    gap: 8px;}
.img-col1, .img-col2{
  width:46%;
  padding:15px 15px 20px 15px;
  border-radius:18px;
  text-align:center;
  display:flex;
  flex-direction:column;
  align-items:center;
  /*justify-content:center;*/
  margin:auto;
}
.img-col1 img, .img-col2 img{margin-bottom:20px;}
.img-col2 img{width:70px;height:70px;}
.a-button{
  border-radius:10px;
  padding:8px 12px 6px 12px;
  background-color:#3173BD;
  font-family:"League Spartan", Sans-serif;
  font-weight:600;
  color:white !important;
  text-decoration:none;
  font-size:14px;
}
.img-col1-back{background-color:transparent;padding:0;}
.img-col2 > div{
  background-color:#E6EBED6E;
  border-radius:15px;
  padding:15px;
  width:100%;
  text-align:center;
  margin-bottom:15px;
  /*box-shadow:0 2px 6px rgba(0,0,0,0.05);*/
}
.img-col2 > div img{
  border-radius:50%;
  width:80px;
  height:80px;
  margin-bottom:10px;
   object-fit: cover;
    object-position: center;
    background: white;
}
.img-col1-back p{font-size:15px;line-height:15px;}
.img-col1-back .a-button{
  margin-top:7px;
  font-size:11px;
  border-radius:5px;
  padding:6px 12px 4px 12px;
  background-color:#3173BDBD;
  font-weight:400;
}
.col-margin{margin-top:25px;    width: 45%;
    margin-left: 10px;}
    
.col-margin h4{
    color:red;
    font-size:20px;
}   

.col-margin p{
    color:red;
    font-size:16px;
}   

.col-margin{
    text-align:center;
}

img.farm-img {
    width: 140px !important;
    height: 80px !important;
}

.img-col-main-margin{margin-top:2px;margin-bottom:15px;    margin-left: 10px;}

.col-sm-4.img-col.img-col2.img-col1-back {
    width: 46%;
    margin: auto;
}
.img-col1-back {
    background-color: transparent;
    padding: 0;
    width: 46%;
        margin: 0px !important;
    /*margin-left: 12px !important;*/
}

.img-border div img{ 
    border-radius: 5px;
    width: 135px;
    height: auto;
}
.img-border img{
      border-radius: 5px;
}
.col-sm-4.img-col.img-col2.img-col1-back div h4 {
    text-transform: capitalize;
}
  </style>
</head>
<body>
 <?php
// ✅ Include WordPress and start session
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');

if (!session_id()) {
    session_start();
}

// ✅ Default values
$user_type = $_SESSION['user_type'] ?? '';
$post_job_url = 'https://rumicare.bibigadgets.com/user-login-form/';
?>


<div class="row">
  <div class="col-sm-4">
    <h4>Hire skilled dairy professionals</h4>
    <p>Post jobs, view verified farm offers, and hire insights quickly.</p>
  </div>
  <div class="col-sm-4">
    <h4>Find your next dairy job</h4>
    <p>Upload your CV, apply with one click and chat directly.</p>
  </div>
</div>
  
<div class="row img-col-main">
 <div class="col-sm-4 img-col img-col1 img-border">
    <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/3wrsdsd.png" alt="Post a job">
<a 
    class="a-button" 
    href="#" 
    onclick="handlePostJobClick(event)"
>
    Post a Job
</a></div>

  <div class="col-sm-4 img-col img-col2">
    <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/10/2ewdszx.png" alt="Create Profile">
    <a class="a-button" href="<?php 
        // Check login session
        if (isset($_SESSION['user_id']) && !empty($_SESSION['user_id'])) {
            echo esc_url('https://rumicare.bibigadgets.com/registration-page/');
        } else {
            echo esc_url('https://rumicare.bibigadgets.com/user-login-form/');
        }
    ?>">Create Profile</a>
</div>

</div>
  
<div class="row">
  <div class="col-sm-4 col-margin">
    <h4>For Employees</h4>
    <p>Trending Jobs</p>
  </div>
  <div class="col-sm-4 col-margin">
    <h4>For Employers</h4>
    <p>Featured Offers</p>
  </div>
</div>

<?php
// ============================
// Database Connection
// ============================
$db_host = 'localhost';
$db_user = 'bibigadg_wp_snqtv';
$db_pass = 'Uu%aiqPE?6het28_';
$db_name = 'bibigadg_wp_gecpv';

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
if ($conn->connect_error) {
    die("<p style='color:red;'>Database connection failed: " . $conn->connect_error . "</p>");
}
?>

<div class="row img-col-main img-col-main-margin">

 <!-- Left Column: Farmers -->
<?php
$farmers_sql = "
    SELECT id, role, farm_name, city, salary_package, farm_about 
    FROM farm_jobs 
    WHERE job_visibility = 'public'
    AND status = 'approved'
    ORDER BY id DESC
";


$farmers = $conn->query($farmers_sql);
?>
<div class="col-sm-4 img-col img-col1-back img-col2 img-border">

  <?php if ($farmers && $farmers->num_rows > 0): ?>
    <?php while ($f = $farmers->fetch_assoc()): ?>
      <div>
        <img class="farm-img" src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/3wrsdsd.png" alt="Farm Profile">
        <h4><?php echo htmlspecialchars($f['farm_name']); ?></h4>
        <p><?php echo htmlspecialchars($f['city']); ?></p>
        <p>Expected salary: <?php echo htmlspecialchars($f['salary_package']); ?></p>
        <a class="a-button" href="https://rumicare.bibigadgets.com/farmar-detail-page/?id=<?php echo $f['id']; ?>">View More</a>
      </div>
    <?php endwhile; ?>
  <?php else: ?>
    <p>No public farm jobs found.</p>
  <?php endif; ?>

</div>



<?php
// Employees query joining user_info, user_profiles, and user_experience
$employees_sql = "
SELECT 
    p.user_id,      -- add user_id here
    u.username,
    p.city,
    p.image,
    MIN(e.start_date) AS first_start,
    MAX(COALESCE(e.end_date, CURDATE())) AS last_end
FROM user_profiles AS p
INNER JOIN user_info AS u ON u.id = p.user_id
LEFT JOIN user_experience AS e ON e.user_id = p.user_id
GROUP BY p.user_id, u.username, p.city, p.image
ORDER BY p.user_id DESC
LIMIT 10
";


$employees = $conn->query($employees_sql);
$upload_base_url = get_template_directory_uri() . '/page-templates/uploads/';
?>

<div class="col-sm-4 img-col img-col2 img-col1-back">
  <?php if ($employees && $employees->num_rows > 0): ?>
    <?php while ($row = $employees->fetch_assoc()): ?>
      <?php
      // Profile image
      $image = !empty($row['image'])
        ? $upload_base_url . basename($row['image'])
        : 'https://rumicare.bibigadgets.com/wp-content/uploads/2025/10/3resdxc.png';

      // Calculate experience span
      $experience_text = "N/A";
      if (!empty($row['first_start']) && !empty($row['last_end'])) {
          try {
              $start = new DateTime($row['first_start']);
              $end = new DateTime($row['last_end']);
              $diff = $start->diff($end);

              $parts = [];
              if ($diff->y > 0) $parts[] = $diff->y . ' yr' . ($diff->y > 1 ? 's' : '');
              if ($diff->m > 0) $parts[] = $diff->m . ' mo' . ($diff->m > 1 ? 's' : '');
              if ($diff->d > 0 && $diff->y == 0) $parts[] = $diff->d . ' day' . ($diff->d > 1 ? 's' : '');
              if (empty($parts)) $parts[] = '0 mo';

              $experience_text = implode(' ', $parts);
          } catch (Exception $e) {
              $experience_text = 'N/A';
          }
      }
      ?>
      <div>
        <img src="<?php echo esc_url($image); ?>" alt="User Profile">
        <h4><?php echo htmlspecialchars($row['username']); ?></h4>
        <p><?php echo htmlspecialchars($row['city']); ?></p>
        <p>Total Experience:<br> <?php echo htmlspecialchars($experience_text); ?></p>
<a class="a-button" href="https://rumicare.bibigadgets.com/user-detail-page/?id=<?php echo $row['user_id']; ?>">View More</a>
      </div>
    <?php endwhile; ?>
  <?php else: ?>
    <p>No employees found.</p>
  <?php endif; ?>
</div>

<?php $conn->close(); ?>

<script>
function handlePostJobClick(e) {
    e.preventDefault();

    // Inject PHP session info into JS
    const userType = "<?php echo $user_type; ?>";

    if (userType === "farm") {
        // ✅ Farmer → Go to farm form
        window.location.href = "https://rumicare.bibigadgets.com/farma-form/";
    } 
    else if (userType === "user") {
        // ⚠️ Normal user → show alert + redirect to login
        alert("Please login with your farmer account to post a job.");
        window.location.href = "https://rumicare.bibigadgets.com/user-login-form/";
    } 
    else {
        // 🚫 Not logged in → redirect to login
         alert("Please login with your farmer account to post a job.");
        window.location.href = "https://rumicare.bibigadgets.com/user-login-form/";
    }
}
</script>

</body>
</html>

<?php get_footer('custom'); ?>
